<?
use Bitrix\Main\Application;
use Bitrix\Main\EventManager;
use Bitrix\Main\IO\File;
use Bitrix\Main\ModuleManager;
use Bitrix\Main\SystemException;

global $MESS;
$PathInstall = str_replace("\\", "/", __FILE__);
$PathInstall = substr($PathInstall, 0, strlen($PathInstall)-strlen("/index.php"));
IncludeModuleLangFile($PathInstall."/install.php");
include($PathInstall."/version.php");

if(class_exists("bxab_smtpmail")) return;
Class bxab_smtpmail extends CModule{
	var $MODULE_ID = "bxab.smtpmail";
	var $MODULE_VERSION;
	var $MODULE_VERSION_DATE;
	var $MODULE_NAME;
	var $MODULE_DESCRIPTION;
	var $PARTNER_NAME;
	var $PARTNER_URI;
	var $MODULE_GROUP_RIGHTS = "Y";
	private $eventManager;
	function __construct(){
        $arModuleVersion = array();
		$path = str_replace("\\", "/", __FILE__);
		$path = substr($path, 0, strlen($path) - strlen("/index.php"));
		include($path."/version.php");
		if (is_array($arModuleVersion) && array_key_exists("VERSION", $arModuleVersion)){
			$this->MODULE_VERSION = $arModuleVersion["VERSION"];
			$this->MODULE_VERSION_DATE = $arModuleVersion["VERSION_DATE"];
		}else{
			$this->MODULE_VERSION = SMTPMAIL_VERSION;
			$this->MODULE_VERSION_DATE = SMTPMAIL_VERSION_DATE;
		}
		$this->PARTNER_NAME = GetMessage("SMTPMAIL_PARTNER_NAME");
		$this->PARTNER_URI = "https://bxab.ru";
		$this->MODULE_NAME = GetMessage("SMTPMAIL_MODULE_NAME");
		$this->MODULE_DESCRIPTION = GetMessage("SMTPMAIL_DESCRIPTION");
		$this->eventManager = EventManager::getInstance();
	}
	
	function InstallDB(){
			global $DB;
        	return true;
   	}
	function UnInstallDB(){
		global $DB;
        return true;
    }

	function DoInstall(){
		global $APPLICATION;
		$SMTPMAIL_RIGHT = $APPLICATION->GetGroupRight("bxab.smtpmail");
		if ($SMTPMAIL_RIGHT == "W"){
			$this->InstallDB();
			$this->InstallEvents();
			$APPLICATION->IncludeAdminFile(GetMessage("SMTPMAIL_INSTALL_TITLE"), $_SERVER["DOCUMENT_ROOT"]."/bitrix/modules/bxab.smtpmail/install/step1.php");
		}
	}

	function DoUninstall(){
		global $APPLICATION, $step, $DB;
		$SMTPMAIL_RIGHT = $APPLICATION->GetGroupRight("bxab.smtpmail");
		if ($SMTPMAIL_RIGHT == "W"){
			$this->UnInstallDB();
			$step = intval($step);
			if ($step < 2){
				$this->UnInstallEvents();
				$APPLICATION->IncludeAdminFile(GetMessage("SMTPMAIL_UNINSTALL_TITLE"), $_SERVER["DOCUMENT_ROOT"]."/bitrix/modules/bxab.smtpmail/install/unstep1.php");
			}elseif ($step == 2){
				$APPLICATION->IncludeAdminFile(GetMessage("SMTPMAIL_UNINSTALL_TITLE"), $_SERVER["DOCUMENT_ROOT"]."/bitrix/modules/bxab.smtpmail/install/unstep2.php");
			}
		}
	}
	public function InstallEvents()
    {
        foreach (self::getEvents() as $event) {
            //$this->eventManager->registerEventHandler($event[0], $event[1], $this->MODULE_ID, $event[2], $event[3]);
			$this->eventManager->registerEventHandlerCompatible($event[0], $event[1], $this->MODULE_ID, $event[2], $event[3]);
        }
    }

    public function UnInstallEvents()
    {
        foreach (self::getEvents() as $event) {
            $this->eventManager->unRegisterEventHandler($event[0], $event[1], $this->MODULE_ID, $event[2], $event[3]);
        };
    }
	private function getEvents(): array
    {
        return [
            /*[
                'main',
                'OnBeforeEventSend',
                'CAllSmtpmail',
                'mailBeforeEventSend',
            ],
            [
                'main',
                'OnBeforeEventAdd',
                'CAllSmtpmail',
                'mailBeforeEventAdd',
            ],*/
			[
                'main',
                'OnBeforeMailSend',
                'CAllSmtpmail',
                'mailBeforeMailSend',
            ],
            
        ];
    }

	function GetModuleRightList(){
		$arr = array(
			"reference_id" => array("D", "R", "W"),
			"reference" => array(
				"[D] ".GetMessage("SMTPMAIL_DENIED"),
				"[R] ".GetMessage("SMTPMAIL_VIEW"),
				"[W] ".GetMessage("SMTPMAIL_WRITE"))
			);
		return $arr;
	}
}
?>