<?php
require_once($_SERVER["DOCUMENT_ROOT"] . "/bitrix/modules/main/include/prolog_admin_before.php");
 
use \Bitrix\Iblock\PropertyEnumerationTable;
use Bitrix\Main\Grid\Options as GridOptions;
use Bitrix\Main\UI\PageNavigation;
 
IncludeModuleLangFile(__FILE__);
CModule::IncludeModule('bxab.smtpmail');
$APPLICATION->SetTitle("Просмотр логов модуля отправки почты ыерез внешний ящик по SMTP");
$list_id = "a_debug_mail"; //Индификатор таблицы
 $grid_options = new GridOptions($list_id);
 //$sort = $grid_options->GetSorting(['sort' => ['ID' => 'DESC'], 'vars' => ['by' => 'by', 'order' => 'order']]);
 
/**
 * Навигация
 */
$nav_params = $grid_options->GetNavParams();
 
$nav = new PageNavigation('request_list');
 
$nav->allowAllRecords(true)//Показать все
        ->setRecordCount($DB->query("SELECT COUNT(*) as CNT FROM ".$list_id)->fetch()['CNT'])//Для работы кнопки "показать все"
        ->setPageSize($nav_params['nPageSize'])//Параметр сколько отображать на странице
        ->initFromUri();
 
/**
 * Параметры запроса
 */
$sql_where = 'WHERE 1=1';
$sql_joint = '';
$sql_order = 'ORDER BY `DATE_INSERT` DESC';
$sql_limit = 'LIMIT ' . $nav->getLimit();
$sql_offset = 'OFFSET ' . $nav->getOffset();
/**
 * Сортировка
 */
if (($_GET['grid_id'] ?? null) === $list_id) {
    if (isset($_GET['grid_action']) and $_GET['grid_action'] === 'sort') {
        $sql_order = "ORDER BY `{$DB->ForSql($_GET['by'])}` {$DB->ForSql($_GET['order'])}";
    }
}
 
/**
 * Фильтрация
 */
$filterOption = new Bitrix\Main\UI\Filter\Options($list_id);
$filterData = $filterOption->getFilter([]);
$filter = [];
foreach ($filterData as $key => $value) {
    /**
     * Фильтр по датам
     */
    if (stripos($key, 'DATE_INSERT') !== FALSE) {
         //DATE_GIFT_datesel == RANGE,TOMORROW,
        $date_start = strtotime($filterData['DATE_INSERT_from']);
        $date_end = strtotime($filterData['DATE_INSERT_to']);
        $sql_where .= " AND ".$list_id.".DATE_CREATE BETWEEN FROM_UNIXTIME({$date_start}) AND FROM_UNIXTIME({$date_end})";
    }
    /**
     * Фильтр Результат
     */
    if ($key === 'REZULT' && strlen($value) > 0) {
        $sql_where .= " AND ".$list_id.".REZULT='{$value}'";
    }
}
 
/**
 * Весь запрос
 */
$sql_query = <<<EOT
            SELECT 
           `{$list_id}`.`ID` AS `ID`, 
           `{$list_id}`.`DATE_INSERT` AS `DATE_INSERT`, 
           `{$list_id}`.`SUBJ` AS `SUBJ`, 
           `{$list_id}`.`BODY` AS `BODY`, 
           `{$list_id}`.`TO` AS `TO`,  
		   `{$list_id}`.`FROM` AS `FROM`,  
		   `{$list_id}`.`REZULT` AS `REZULT`,  
		   `{$list_id}`.`IP` AS `IP`  
           
           FROM `{$list_id}`
           {$sql_where}
           {$sql_order}
           {$sql_limit}
           {$sql_offset}
EOT;
 
/**
 * Результат запроса для отображения таблицы
 */
$rsData = $DB->query($sql_query);

/**
 * Список фильтров
 */
$filter_list = [
    [
        "id" => "ID",
        'type' => 'number',
        "name" => "Идентификатор",
        "default" => true,
    ],
    [
        "id" => "REZULT",
        'type' => 'text',
        "name" => "Результат",
        "default" => true
    ],
    [
        "id" => "DATE_INSERT",
        'type' => 'date',
        "name" => "Дата",
        "default" => true
    ],
    
];
 
/**
 * Колонки таблицы
 */
$arHeaders = array(
    array("id" => "ID", "name" => "Идентификатор", "sort" => "ID", "align" => "center", "default" => true),
    array("id" => "DATE_INSERT", "name" => "Дата", "sort" => "DATE_INSERT", "align" => "center", "default" => true),
    array("id" => "SUBJ", "content" => "Тема", "sort" => "", "align" => "left", "default" => true),
    array("id" => "BODY", "name" => "Содержание", "sort" => "", "align" => "center", "default" => true),
    array("id" => "TO", "name" => "Кому", "sort" => "TO", "align" => "center", "default" => true),
    array("id" => "FROM", "name" => "От кого", "sort" => "FROM", "align" => "center", "default" => true),
    array("id" => "REZULT", "name" => "Результат", "sort" => "REZULT", "align" => "center", "default" => true),
    array("id" => "IP", "name" => "IP", "sort" => "IP", "align" => "center", "default" => true),
);
 
require($_SERVER["DOCUMENT_ROOT"] . "/bitrix/modules/main/include/prolog_admin_after.php");
?>
<div class="adm-toolbar-panel-container">
    <div class="adm-toolbar-panel-flexible-space">
        <?php
        $APPLICATION->IncludeComponent('bitrix:main.ui.filter', '', [
            'FILTER_ID' => $list_id,
            'GRID_ID' => $list_id,
            'FILTER' => $filter_list,
            'ENABLE_LIVE_SEARCH' => true,
            'ENABLE_LABEL' => true
        ]);
        ?>
    </div>
    <div class="adm-toolbar-panel-align-right">
    </div>
</div>
 
<?php
/**
 * Данные по каждому выбранному элементу таблицы
 */
$list = [];
while ($row = $rsData->fetch()) {
 
    $url_params = http_build_query(
            [
                'CODE_PARTNER' => $row['CODE_PARTNER'],
                'lang' => LANGUAGE_ID,
                'ID' => $row['ID'],
            ]
    );
 
    $list[] = [
        'data' => $row,
        'actions' => [
            [
                'text' => 'Просмотр/Редактирование',
                'default' => true,
				'onclick' => "document.location.href='/bitrix/admin/perfmon_row_edit.php?lang=ru&table_name=a_debug_mail&pk%5BID%5D=".$row['ID']."'",
				
            ],
//            [
//                'text' => 'Удалить',
//                'default' => true,
//                'onclick' => 'if(confirm("Точно?")){document.location.href="?op=delete&id=' . $row['ID'] . '"}'
//            ]
        ]
    ];
}
 
//\Bitrix\Main\Page\Asset::getInstance()->addCss('/bitrix/css/main/grid/webform-button.css');
 
$APPLICATION->IncludeComponent('bitrix:main.ui.grid', '', [
    'GRID_ID' => $list_id,
    'COLUMNS' => $arHeaders,
    'ROWS' => $list,
    'SHOW_ROW_CHECKBOXES' => false,
    'NAV_OBJECT' => $nav,
    'AJAX_MODE' => 'Y',
    'AJAX_ID' => \CAjax::getComponentID('bitrix:main.ui.grid', '.default', ''),
    'PAGE_SIZES' => [
        ['NAME' => '5', 'VALUE' => '5'],
        ['NAME' => '20', 'VALUE' => '20'],
        ['NAME' => '50', 'VALUE' => '50'],
        ['NAME' => '100', 'VALUE' => '100']
    ],
    'AJAX_OPTION_JUMP' => 'N',
    'SHOW_CHECK_ALL_CHECKBOXES' => false,
    'SHOW_ROW_ACTIONS_MENU' => true,
    'SHOW_GRID_SETTINGS_MENU' => true,
    'SHOW_NAVIGATION_PANEL' => true,
    'SHOW_PAGINATION' => true,
    'SHOW_SELECTED_COUNTER' => true,
    'SHOW_TOTAL_COUNTER' => true,
    'SHOW_PAGESIZE' => true,
    'SHOW_ACTION_PANEL' => true,
    'ALLOW_COLUMNS_SORT' => true,
    'ALLOW_COLUMNS_RESIZE' => true,
    'ALLOW_HORIZONTAL_SCROLL' => true,
    'ALLOW_SORT' => true,
    'ALLOW_PIN_HEADER' => true,
    'AJAX_OPTION_HISTORY' => 'N',
    'TOTAL_ROWS_COUNT_HTML' => '<span class="main-grid-panel-content-title">Всего:</span> <span class="main-grid-panel-content-text">' . $nav->getRecordCount() . '</span>',
//    'ACTION_PANEL' => [
//        'GROUPS' => [
//            'TYPE' => [
//                'ITEMS' => [
//                    [
//                        'ID' => 'set-type',
//                        'TYPE' => 'DROPDOWN',
//                        'ITEMS' => [
//                            ['VALUE' => '', 'NAME' => '- Выбрать -'],
//                            ['VALUE' => 'plus', 'NAME' => 'Битые данные'],
//                        ]
//                    ],
//                    [
//                        'ID' => 'edit',
//                        'TYPE' => 'BUTTON',
//                        'TEXT' => 'Редактировать',
//                        'CLASS' => 'icon edit',
//                        'ONCHANGE' => ''
//                    ],
//                    [
//                        'ID' => 'delete',
//                        'TYPE' => 'BUTTON',
//                        'TEXT' => 'Удалить',
//                        'CLASS' => 'icon remove',
//                        'ONCHANGE' => $onchange->toArray()
//                    ],
//                ],
//            ]
//        ],
//    ],
]);
?>
 