var globalCurrentNumberBlock = 0;
var defoltPng1px = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyBpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMC1jMDYwIDYxLjEzNDc3NywgMjAxMC8wMi8xMi0xNzozMjowMCAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNSBXaW5kb3dzIiB4bXBNTTpJbnN0YW5jZUlEPSJ4bXAuaWlkOjkzNjJDRjMwOTJDNzExRjBCOEJBQTcxRDFEQzlDODRGIiB4bXBNTTpEb2N1bWVudElEPSJ4bXAuZGlkOjkzNjJDRjMxOTJDNzExRjBCOEJBQTcxRDFEQzlDODRGIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6OTM2MkNGMkU5MkM3MTFGMEI4QkFBNzFEMURDOUM4NEYiIHN0UmVmOmRvY3VtZW50SUQ9InhtcC5kaWQ6OTM2MkNGMkY5MkM3MTFGMEI4QkFBNzFEMURDOUM4NEYiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz5cDCz5AAAAEElEQVR42mL8//8/A0CAAQAJAQL/abyQ8AAAAABJRU5ErkJggg==';
$( document ).ready(function() {
    startLoad();
	setDropAll();
	setDropRowAll();
	connectBlockAllLoad();
	connectRadiollLoad();
});
function setDropAll(){
	$( ".block-questions" ).draggable({
		handle: ".block-questions_1",
		cursor: "move",
		stop: function( event, ui ) {
			var elem = $("#" + event.target.id);
			elem.css("left", 0); 
			elem.css("top", 0); 
		},
		
		
	});
    $( ".block-questions" ).droppable({
	  hoverClass: "drop-hover", 
      drop: function( event, ui ) {
		  //console.log(ui.draggable);
		 var elem = $("#" + ui.draggable[0].id);
		 var elemAfter = $("#" + event.target.id);
		 if(event.target.id == ui.draggable[0].id){
			 //elem.removeAttr("style"); 
		 }else{
			elem.insertAfter(elemAfter); 
		 }
		$( ".block-questions" ).addClass("animate");
		setTimeout(function () {
			$( ".block-questions" ).removeClass("animate");
			connectBlockAllLoad();
			connectRadiollLoad();
		}, 2000);
      }
    });
}
function setDropOneElement(selector){
	$( selector ).draggable({
		handle: ".block-questions_1",
		cursor: "move",
		stop: function( event, ui ) {
			var elem = $("#" + event.target.id);
			elem.css("left", 0); 
			elem.css("top", 0); 
		},
	});
	
    $( selector ).droppable({
	  hoverClass: "drop-hover", 
      drop: function( event, ui ) {
		 var elem = $("#" + ui.draggable[0].id);
		 var elemAfter = $("#" + event.target.id);
		 if(event.target.id == ui.draggable[0].id){
		 }else{
			elem.insertAfter(elemAfter); 
		 }
		$( ".block-questions" ).addClass("animate");
		setTimeout(function () {
			$( ".block-questions" ).removeClass("animate");
			connectBlockAllLoad();
			connectRadiollLoad();
		}, 2000);
      }
    });
}
/* *************************************************************** */
function setDropRowAll(){
	$(".row-plased-object").each(function(){
		activateDropRow($(this).attr("id"));
	});
}
function activateDropRow(seletorDropRowId){
	//console.log(seletorDropRowId);
	var selector = "#" + seletorDropRowId;
	$( selector ).draggable({
		handle: ".block-questions-row-obj",
		cursor: "move",
		stop: function( event, ui ) {
			var elem = $("#" + event.target.id);
			elem.css("left", 0); 
			elem.css("top", 0); 
		},
	});
	$( selector ).droppable({
	  hoverClass: "drop-hover", 
      drop: function( event, ui ) {
		 var elem = $("#" + ui.draggable[0].id);//Что вставляю
		 var elemInto = $("#" + event.target.id);//Куда вставляю. Или после чего вставляю
		 if(event.target.id == ui.draggable[0].id){
		 }else{
			//elem.insertAfter(elemAfter); 
			elemInto.append(elem);
		 }
		$( ".block-questions" ).addClass("animate");
		setTimeout(function () {
			$( ".block-questions" ).removeClass("animate");
		}, 1000);
      }
    });
}
function startLoad(){
	var max = maxNumber();
	max = parseInt(max);
	$(".addblocknum").val(max);
}
function maxNumber(){
	var maxNumber = 0;
	$(".block-questions").each(function(){
	    var currentNumber = $(this).data("blocknumber");
		currentNumber = parseInt(currentNumber);
		if(currentNumber>maxNumber){
			maxNumber = currentNumber;
		}
		
	});
	maxNumber++;
	globalCurrentNumberBlock = maxNumber;
	$(".curr-text-number").text($(".block-questions.active").data('blocknumber'));
	
	
	return maxNumber;
}
function dellAnswer(eto){
	$(eto).parents("label:first").remove();
}
function setImage(eto){
	var imgBase64 = prompt('Введите изображение в коде base 64:', "");
	if(imgBase64 == null){
	}else{
		$(eto).attr("src",imgBase64);
	}
}
function addRadio(eto){
	var url = "/baform/ajax.php?dd=" + (new Date).getTime();
	var currBlock = $(".curr-text-number").text();
	var isExistEdit = 0;
	
	if(typeof currBlock == 'undefined' || currBlock == null){
		alert("!Ошибка. Не выбран блок-вопрос");
		return true;
	}else{
		if(currBlock.length === 0){
			currBlock = parseInt(currBlock);
		}else{
			isExistEdit = 1;
			currBlock = parseInt(currBlock);
		}
	}
	if(currBlock<1){
		alert("!Ошибка. Не указан блок-вопрос для вставки ответов");
		return true;
	}
	var maxRadio = getMaxRadio(currBlock);
	globalCurrentNumberBlock = currBlock;
	var textRadio = "Здесь отредактируйте ответ на вопрос";
	textRadio = prompt('Введите в латинице без пробелов название сохраняемой конфигурации:', textRadio);
	if(textRadio == null){
		return true;
	}
	
	if(typeof $("[data-blocknumber='" + currBlock + "']") == 'indefined' || $("[data-blocknumber='" + currBlock + "']") == null || $("[data-blocknumber='" + currBlock + "']").length ===0){
		alert("!Ошибка. Не существует блок-вопрос № "+ currBlock);
		return true;
	}
	$.ajax({
        url: url,
        type: "post",
		async: true,
        data: {action:"addradio", currBlock:currBlock, maxRadio:maxRadio, textRadio:textRadio},
			success: function(responseData, textStatus, jqXHR) {
                    total = responseData;
					$("[data-blocknumber='" + currBlock + "']").find(".wrap-answers-radio").append(total);
					
			},
    error: function (responseData, textStatus, errorThrown) {}}); 
	return true;
}
function addTextInput(eto){
	var url = "/baform/ajax.php?dd=" + (new Date).getTime();
	if($(".block-questions.active").length === 0){
		alert("Не указан блок для вставки");
		return true;
	}
	var currBlock = $(".block-questions.active").data("blocknumber");
	var maxInputText=0;
	
	$(".dev-text-input").each(function(){
		var tmp = $(this).data("numbertextinput");
		tmp = parseInt(tmp);
		if(tmp>maxInputText){
			maxInputText = tmp;
		}
	});

	$.ajax({
        url: url,
        type: "post",
		async: true,
        data: {action:"inputText", currBlock: currBlock, maxInputText: maxInputText},
			success: function(responseData, textStatus, jqXHR) {
                    total = responseData;
					$("[data-blocknumber='" + currBlock + "']").find(".wrap-text-input").append(total);
					
			},
    error: function (responseData, textStatus, errorThrown) {}}); 
	return true;
	
}
function getMaxRadio(currBlock){
	//Максимальный идентификатор радиобатона
	var maxR = 0;
	$(".block-questions.active .wrap-answers-radio input").each(function(){	
		    var tmpVal = $(this).data("numberradio");
			tmpVal = parseInt(tmpVal);
			if(tmpVal>maxR){
				maxR = tmpVal;
			}
	});
	return maxR;
}
function addBlock(){
	var max = maxNumber();
	var url = "/baform/ajax.php?dd=" + (new Date).getTime();
	var newEnterNumber = $(".addblocknum").val();
	$.ajax({
        url: url,
        type: "post",
		async: true,
        data: {action:"addblock", max:max, newEnterNumber:newEnterNumber},
			success: function(responseData, textStatus, jqXHR) {
                    total = responseData;
					var ff = $(".dev-cell").append(total);
					$(".block-questions").each(function(){	
					      $(this).removeClass("active");
					});
					$("[data-blocknumber='" + max + "']").addClass("active");
					globalCurrentNumberBlock = max;
					//globalCurrentNumberBlock = newEnterNumber;
					$(".addblocknum").val((max+1));
					$(".curr-text-number").text(max);
					//setDropOneElement("[data-blocknumber='" + max + "']");
					setDropOneElement("[data-blocknumber='" + newEnterNumber + "']");
			},
    error: function (responseData, textStatus, errorThrown) {}}); 
	return true;
}
function addRowBlock(){
	var numberAfter = prompt('Введите номер блока, после которого вставить строкову область:', "");
	if(numberAfter === null){
		alert("Не указан номер блока");
		return true;
	}
	var isBlockExists = getNumberBlock(numberAfter);
	if(isBlockExists === 0){
		alert("Не найден блок с номером " + numberAfter);
		return true;
	}
	var maxRowObject = getMaxRowObject();
	maxRowObject++;
	var html = '<div data-rowobjectnimber="' + maxRowObject + '" class="row-plased-object" id="row-object-' + maxRowObject + '">\
		<div class="block-questions-row-obj">\
			<span class="icon-dell" onclick="return dellRowObject(this);" title="Удалить эту область со всем содержимым (Х)">❌</span>\
			Область размещения блоков в строку\
		</div>\
	</div>';
	
	$("[data-blocknumber='" + numberAfter + "']").after(html);
	activateDropRow('row-object-' + maxRowObject);
	return true;
}
function dellRowObject(eto){
	$(eto).parents(".row-plased-object:first").remove();
	return true;
}
function getNumberBlock(numberAfter){
	var numberExist = 0;
	 $("#blockid-" + numberAfter).each(function(){
	    numberExist = 1;
	});
	return numberExist;
}
function getMaxRowObject(){
	maxRowObject = 0;
	$(".row-plased-object").each(function(){
	    var tmp = $(this).data("rowobjectnimber");
		tmp = parseInt(tmp);
		if(tmp>maxRowObject){
			maxRowObject = tmp;
		}
		
	});
	return maxRowObject;
}
function showRezultAnimate(){
	//Исчезновение
	if(jQuery("[rel='styleDis']").length>0 || jQuery("[rel='styleShow']").length>0){
		jQuery("[rel='styleDis']").remove();
		jQuery("[rel='styleShow']").remove();	
		return true;
	}

	
	var styleDis = '<style type="text/css" rel="styleDis">';
	
	
	console.log(globaEffectOut);
	console.log(globaEffectIn);
	console.log(globalDisApp);
	console.log(globalApp);
	
	var newClassDis = globalDisApp.replaceAll(".disappeared-img img",".wrap-rezult-step1");
	styleDis = styleDis + newClassDis;
	styleDis = styleDis + '</style>';
	jQuery("body").append(styleDis);
	
	//Появление
	
	var styleShow = '<style type="text/css" rel="styleShow">';
	var newClassApp = globalApp.replaceAll(".appearance-img img",".wrap-rezult-step2");
	styleShow = styleShow + newClassApp;
	styleShow = styleShow + '</style>';
	jQuery("body").append(styleShow);
	setTimeout(function () {
			//jQuery("[rel='styleDis']").remove();
			//jQuery("[rel='styleShow']").remove();
			
	}, 5000);
	return true;
	
}
function savePrj(){
	var namePrj = "";
	var currentName = $(".select-name-prj").val();
	if(typeof currentName !== 'undefined' || currentName !== null){
			if(currentName == "0"){
				namePrj = "";
			}else{
				namePrj = currentName;
			}
	}
	namePrj = prompt('Введите в латинице без пробелов название сохраняемой конфигурации:', namePrj);
	var noValue = 0;
	if(typeof namePrj == 'undefined' || namePrj == null) {
		noValue = 1;
	}else {
		if(namePrj.length === 0) {
			noValue = 1;
		}
	}
	if(noValue === 1){
		alert("Не введено название проекта");
		return true;
	}
	
	var url = "/baform/ajax.php?dd=" + (new Date).getTime();
	var html = $(".dev-cell").html();

	/* **************************************** */
	var emailfrom = $(".emailfrom").val();
	if(typeof emailfrom == 'undefined' || emailfrom == null) {
		emailfrom = "";
	}

	var emailto = $(".emailto").val();
	if(typeof emailto == 'undefined' || emailto == null) {
		emailto = "";
	}

	var subject_email_to_admin = $(".subject_email_to_admin").val();
	if(typeof subject_email_to_admin == 'undefined' || subject_email_to_admin == null) {
		subject_email_to_admin = "Ответ на опросник/квиз";
	}

	var subject_email_to_user = $(".subject_email_to_user").val();
	if(typeof subject_email_to_user == 'undefined' || subject_email_to_admin == null) {
		subject_email_to_user = "Ответ на опросник/квиз";
	}

	var select_template = $(".select-template").val();
	if(typeof select_template == 'undefined' || select_template == null) {
		select_template = "template";
	}

	var send_to_user = "N";
	if($(".send_to_user").prop("checked") === true) {
		send_to_user = "Y";
	}
	
	var no_images_show = "N";
	if($(".no-images-show").prop("checked") === true) {
		no_images_show = "Y";
	}
	var effectDis = "";//Латиница название эффекта Исчезновение
	var effectApp = "";//Латиница название эффекта Появление
	var speedDis = "";//Скорость эффекта исчезновение
	var speedApp = "";//Скорость эффекта появление
	var zaderjkaApp = "";//Задержка перед появдением
	var strDis = "";// Сгенерированный css исчезновение
	var strApp = "";// Сгенерированный css Появление
	if(select_template == 'animate_effects'){
		effectDis = globaEffectOut;
		effectApp = globaEffectIn;
		speedDis = globalSpeedDis;
		speedApp = globalSpeedApp;
		zaderjkaApp = $('.zaderjka').val();
		strDis = globalDisApp;
		strApp = globalApp;
	}

	/* **************************************** */

	$.ajax({
        url: url,
        type: "post",
		async: true,
        data: {
			action:"saveprj",
			html:html,
			filename:namePrj,
			emailfrom:emailfrom,
			emailto:emailto,
			subject_email_to_admin:subject_email_to_admin,
			subject_email_to_user:subject_email_to_user,
			select_template:select_template,
			send_to_user:send_to_user,
			no_images_show:no_images_show,
			
			effectDis:effectDis,
			effectApp:effectApp,
			speedDis:speedDis,
			speedApp:speedApp,
			zaderjkaApp:zaderjkaApp,
			strDis:strDis,
			strApp:strApp
		},
			success: function(responseData, textStatus, jqXHR) {
                    total = responseData;
					window.location = "/baform/index.php";
			},
    error: function (responseData, textStatus, errorThrown) {}}); 
	return true;
}
function newPrj(){
	var namePrj = "";
	var currentName = $(".select-name-prj").val();
	if(typeof currentName !== 'undefined' || currentName !== null){
			if(currentName == "0"){
				namePrj = "";
			}else{
				namePrj = currentName;
			}
	}
	namePrj = prompt('Введите в латинице без пробелов название сохраняемой конфигурации:', namePrj);
	var noValue = 0;
    if(typeof namePrj == 'undefined' || namePrj == null) {
        noValue = 1;
    }else {
        if(namePrj.length === 0) {
            noValue = 1;
        }
    }
    if(noValue === 1){
        alert("Не введено название проекта");
        return true;
    }
	var url = "/baform/ajax.php?dd=" + (new Date).getTime();
	$.ajax({
        url: url,
        type: "post",
		async: true,
        data: {action:"newprj", filename:namePrj},
			success: function(responseData, textStatus, jqXHR) {
                    total = responseData;
					window.location = "/baform/index.php";
			},
    error: function (responseData, textStatus, errorThrown) {}}); 
	return true;
}
function loadPrj(){
	var namePrj = "";
	var currentName = $(".select-name-prj").val();
	if(typeof currentName !== 'undefined' || currentName !== null){
			if(currentName == "0"){
				namePrj = "";
			}else{
				namePrj = currentName;
			}
	}
	if(namePrj.length === 0){
		alert("Не указано название проекта");
		return true;
	}
	var url = "/baform/ajax.php?dd=" + (new Date).getTime();
	$.ajax({
        url: url,
        type: "post",
		async: true,
        data: {action:"loadprj", filename:namePrj},
			success: function(responseData, textStatus, jqXHR) {
                    total = responseData;
					window.location = "/baform/index.php";
			},
    error: function (responseData, textStatus, errorThrown) {}}); 
	return true;
}
function dellBclock(eto){
	$(eto).parents(".block-questions:first").remove();
	var maxBk = maxNumber();
	$(".block-questions").each(function(){	
	     $(this).removeClass("active");
	});
	$("[data-blocknumber='" + (maxBk-1) + "']").addClass("active");
	globalCurrentNumberBlock = maxBk-1 ;
	$(".addblocknum").val(maxBk);
	$(".curr-text-number").text((maxBk-1));
	return true;
}
function closePopup(eto) {
	$(eto).parents(".wrap-popup-edit-block:first").remove();
}
function savePopup(eto) {
	//Номер блока
	var newNumber = $(".new-number-bclock").text();
	var currNum = $(".block-questions.active").data("blocknumber");
	currNum = parseInt(currNum);
	if(typeof newNumber !== 'undefined' && newNumber !== null) {
		if(newNumber.length>0) {
			newNumber = parseInt(newNumber);
		}else {
			newNumber = parseInt(currNum);
		}
	}else {
		newNumber = parseInt(currNum);
	}
	if(newNumber == currNum) {
	}else {
		currNum = newNumber;
		var dublBlock = findDublBlock(newNumber);//Поиск блока с таким же номером
		if(dublBlock === true){
			alert("Блок с таким номером уже существует");
			return true;
		}
		setNewNumberBlock(newNumber, currNum);
	}
	$(".addblocknum").val((currNum + 1));
	$(".curr-text-number").text(currNum);
	globalCurrentNumberBlock = currNum;

	//Количество строк
	if($(".block-questions.active").find('.count-row-number').length > 0) {
		var oldCountRow=$(".block-questions.active").find('.count-row-number').text();
	}else {
		var oldCountRow=2;
	}
	oldCountRow = parseInt(oldCountRow);

	if($('.new-number-column').text().length>0) {
		var newCountRow=$('.new-number-column').text();
		newCountRow = parseInt(newCountRow);
	}else {
		var newCountRow= 2;
	}

	if($(".block-questions.active").find('.count-row-number').length > 0) {
		$(".block-questions.active").find('.count-row-number').text(newCountRow);
	}else {
		var html_1='<span class="column-row icon-dell icon-edit">в строку по <span class="count-row-number">' + newCountRow + '</span> шт.</span>';
		$(".block-questions.active").prepend(html_1);
	}
	$(".block-questions.active").data("radiorowcount", newCountRow);
	$(".block-questions.active").attr("data-radiorowcount", newCountRow);

	closePopup(eto);
}
function openPopup(eto) {
	$(".block-questions").each(function(){
		$(this).removeClass("active");
	});
	$(eto).parents(".block-questions:first").addClass("active");
	var currNum = $(eto).parents(".block-questions:first").data("blocknumber");
	if($(eto).parents(".block-questions:first").find('.count-row-number').length > 0) {
		var countRow=$(eto).parents(".block-questions:first").find('.count-row-number').text();
	}else {
		var countRow= 2;
	}
	var html='<div class="wrap-popup-edit-block">\n' +
		'\t<div class="popup-edit-block">\n' +
		'\t\t<div class="close-popup" title="Закрыть" onclick="closePopup(this);">&#10007;</div>\n' +
		'\t\t<div class="title-popup-text">Если нужно укажите другой номер для этого блока:</div>\n' +
		'\t\t<div class="title-popup-text-edit new-number-bclock" contenteditable="true">' + currNum + '</div>\n' +
		'\t\t\n' +
		'\t\t<div class="title-popup-text">Варианты ответов (радио-кнопки) расположить по ... в строку:</div>\n' +
		'\t\t<div class="title-popup-text-edit new-number-column" contenteditable="true">' + countRow + '</div>\n' +
		'\t\t<div class="wrap-button-pop">\n' +
		'\t\t\t<button class="popup-button popup-button2" onclick="closePopup(this);">Отменить</button>\n' +
		'\t\t\t<button class="popup-button popup-button1" onclick="savePopup(this);">Сохранить</button>\n' +
		'\t\t</div>\t\n' +
		'\t</div>\n' +
		'</div>';
	$('body').append(html);

}
function setActiveBclock(eto){
	//Активирую и заодно даю возможность сменить номер блока
	/*$(".block-questions").each(function(){
	     $(this).removeClass("active");
	});
	var currNum = $(eto).parents(".block-questions:first").data("blocknumber");
	$(eto).parents(".block-questions:first").addClass("active");
	//Попытка сменить номер блока
	var newNumber = prompt('Если нужно укажите другой номер для этого блока:', currNum);
	if(newNumber === null){
	}else{
		 if(newNumber == currNum){
		 }else{
			 currNum = newNumber; 
			 var dublBlock = findDublBlock(newNumber);//Поиск блока с таким же номером
			 if(dublBlock === true){
				 alert("Блок с таким номером уже существует");
				 return true;
			 }
			 setNewNumberBlock(newNumber, currNum);
		 }
	}
	currNum = parseInt(currNum);
	
	$(".addblocknum").val((currNum + 1));
	$(".curr-text-number").text(currNum);
	globalCurrentNumberBlock = currNum;*/
	//Вариант в попап окне
	openPopup(eto);
	return true;
}
function setMoveBclock(eto){
	var afterBlock = prompt('Введите номер блока, после которого нужно поставить этот блок:', '');
	if(afterBlock === null){
		return true;
	}
	afterBlock = parseInt(afterBlock);
	var element = $("[data-blocknumber='" + afterBlock + "']");
	if(element.length === 0){
		alert("Такой блок не существует");
		return true;
	}
	element.after($(eto).parents(".block-questions:first"));
	return true;
}
function findDublBlock(newNumber){
	var isExist = 0;
	$(".block-questions").each(function(){
		if($(this).data("blocknumber") == newNumber){
			isExist = 1;
		}
	});
	if(isExist === 1){
		return true;
	}
	return false;
}
function setNewNumberBlock(newNumber, currNum){
	//Меняю номер блока
	$(".block-questions.active").data("blocknumber", newNumber).attr("data-blocknumber", newNumber).attr("id", 'blockid-' + newNumber);
	$(".block-questions.active").find(".block-questions_1").text("Блок № " + newNumber);
	// Меняю номер вопроса в радио кнопках
	var iz = 0;
	$(".block-questions.active .wrap-answers-radio label").each(function(){	
		iz++;
		$(this).find("input").attr("name", "question-" + newNumber);
		$(this).find("input").attr("data-numberradio", iz);
		$(this).find("input").data("numberradio", iz);
		
		$(this).find("input").attr("id", "question-" +  newNumber + "-answer-" + iz);
		$(this).attr("for", "question-" + newNumber + "-answer-" + iz);
	});
	
	return true;
}
function addNextButton(eto){
	var html = '<button title="Удалить эту кнопку" class="next-button" onclick="return followNext(this);">&#10060;Далее</button> ';
	$(".block-questions.active .wrap-next-button").append(html);
	return true;
}
function addPrevButton(eto){
	var html = '<button title="Удалить эту кнопку" class="prev-button" onclick="return followPrev(this);">&#10060;Назад</button> ';
	$(".block-questions.active .wrap-prev-button").append(html);
	return true;
}
function addSendButton(eto){
	var html = '<button title="Удалить эту кнопку" class="send-button" onclick="return setSendForm(this);">&#10060;Отправить</button> ';
	$(".block-questions.active .wrap-next-button").append(html);
	return true;
}
function addFileInput(eto){
	var html = '<label for="myFile">Выбор фалов(до 5 штук):</label>\
				<input class="cls-file" type="file" id="#ID_FILE#" name="#ID_FILE#">\
				<span class="file-dell" onclick="devDellFile(this);">&#10007;</span>';
	$(".block-questions.active .wrap-file-input").append(html);
	return true;
}
function setSendForm(eto){
	$(eto).remove();
	return true;
}
function followNext(eto){
	$(eto).remove();
	return true;
}
function followPrev(eto){
	$(eto).remove();
	return true;
}

function devDellFile(eto){
	$(eto).parents(".wrap-file-input").html("");
	return true;
}

function setEmailInputText(eto) {
	var element = $(eto).parents("label:first").find("input");
	if(element.data("isemail") == 1) {
		element.data("isemail", 0);
		element.attr("data-isemail", 0);
		if(element.hasClass("isemail") == true){
			element.removeClass("isemail");
		}
	}else {
		element.data("isemail", 1);
		element.attr("data-isemail", 1);
		if(element.hasClass("isemail") == false){
			element.addClass("isemail");
		}
		/* ********************* */
		if(element.data("isphone") == 1) {
			element.data("isphone", 0);
			element.attr("data-isphone", 0);
			if(element.hasClass("isphone") == true){
				element.removeClass("isphone");
			}
		}
		/* ****  */
	}
	return true;
}

function setPhoneInputText(eto) {
	var element = $(eto).parents("label:first").find("input");
	if(element.data("isphone") == 1) {
		element.data("isphone", 0);
		element.attr("data-isphone", 0);
		if(element.hasClass("isphone") == true){
			element.removeClass("isphone");
		}
	}else {
		element.data("isphone", 1);
		element.attr("data-isphone", 1);
		if(element.hasClass("isphone") == false){
			element.addClass("isphone");
		}
		/* ********************* */
		if(element.data("isemail") == 1) {
			element.data("isemail", 0);
			element.attr("data-isemail", 0);
			if(element.hasClass("isemail") == true){
				element.removeClass("isemail");
			}
		}
		/* ****  */
	}
	return true;
}


function showStaticText(){
	$(".block-questions.active .wrap-static-text").addClass("show");
}
function hideStaticText(){
	$(".block-questions.active .wrap-static-text").removeClass("show");
}
function dellInputText(eto){
	$(eto).parents("label:first").remove();
	$(".block-questions").each(function(){
		$(this).removeClass("active");
	});
	$(eto).parents(".block-questions:first").addClass("active");
}
function setActiveBlock(eto){
	$(".block-questions").each(function(){	
	     $(this).removeClass("active");
	});
	$(eto).parents(".block-questions:first").addClass("active");
	var currIndex =$(eto).parents('.block-questions').data("blocknumber");
	$(".curr-text-number").text(currIndex);
	globalCurrentNumberBlock = currIndex;
	return true;
}

/************************ Установка стрелочек между блоками */
var listLineObject =[];
function showLinersConnect(){
	$(".wrap-block-connect").addClass("show");
	return true;
}
function hideLinersConnect(){
	$(".wrap-block-connect").removeClass("show");
	return true;
}
function setConnectLineblock(eto){
	$(eto).attr("value", $(eto).val());
	connectBlock(eto);
}

function setConnectLineRadio(eto){
	var idTo = $(eto).val();
	var isEmty = 0;
	var idFrom = $(eto).parents(".block-questions:first").attr("id");
	var indexFrom = $(eto).parents(".block-questions:first").data("blocknumber");
	
	if(("blockid-" + idTo) == idFrom){
		alert("Соединение сам-на-себя. Не пойдёт");
		return true;
	}
	
	if(typeof idTo == "undefined" || idTo == null){
		isEmty = 1;
	}else{
		if(idTo.length === 0){
			isEmty = 1;
		}
	}
	$(eto).attr("value", $(eto).val());
	if(isEmty === 1){//Очищаю старую линию если есть
		var size  = listLineObject.length;
		for(var iz=0; iz<size; iz++){
			if(listLineObject[iz].line.start.id == $(eto).parents("label:first").attr("id")){
				listLineObject[iz].line.hide();
				listLineObject.splice(iz, 1);
				//size--;
			}
		}
		return true;
	}
	//var start = $(eto).parents("label:first")[0];
	//var start = $(eto).parents(".quiz__answer-item:first").find(".wr-text-circle-dev")[0];
	var start = $(eto).parents(".quiz__answer-item:first").find(".quiz__answer-item-circle")[0];
	
	var end = $("[data-blocknumber='" + idTo + "']")[0];
	
	if(typeof start == "undefined" || typeof end == "undefined"){
		if(typeof start == "undefined"){
			alert("Не правильно указан стартовый блок.");
		}
		if(typeof end == "undefined"){
			console.log($(eto).parents("label:first,div:first"));
			alert("Не правильно указан конечный блок. ID куда=" + idTo + " от ID=" + $(eto).parents("label:first").attr("id"));
		}
		return true;
	}
	//console.log(start);
	//console.log(end);
	$("[data-blocknumber='" + idTo + "']").data("indexfrom", indexFrom).attr("data-indexfrom", indexFrom);
	var line = new LeaderLine(start,end);
	line.color = 'rgba(30, 130, 250, 0.5)';
    line.setOptions({startSocket: 'left', endSocket: 'top'});
	//line.setOptions({startSocket: 'bottom', endSocket: 'top'});
    //line.path = 'straight';
	//line.path = 'grid';
	line.path = 'fluid';
	line.startSocketGravity = [-50,80];
	line.endSocketGravity = [10,-50]
	
	line.size = 3;
	//Сохраняю массив линий
	var size  = listLineObject.length;
	
	for(var iz=0; iz<size; iz++){
		if(listLineObject[iz].line.start.id == $(eto).parents("label:first").attr("id")){
			listLineObject[iz].line.hide();
			listLineObject.splice(iz, 1);//Если повтор старую линию удаляю
			size--;
		}
	}
	size  = listLineObject.length;
	listLineObject[size] = {};
	listLineObject[size] = {line};
	return true;	
}

function insertRezultFillForm(){
	if($(".block-questions.active").length === 0){
		alert("Не указан блок для вставки");
		return true;
	}
	var currBlock = $(".block-questions.active").data("blocknumber");
	var html = '<div class="rezult-fill-form">В этом блоке будет выведен результат заполнения шагов формы \
	<span class="icon-dell icon-fill-form" onclick="return dellRezultFillForm(this);" title="Удалить поле (Х)">❌</span>\
	</div>';
	$("[data-blocknumber='" + currBlock + "']").find('.wrap-file-input').after(html);
	return true;	
}
function dellRezultFillForm(eto){
	$(eto).parents(".rezult-fill-form:first").remove();
}

function connectBlockAllLoad(){
	$(".connect-block").each(function(){
		connectBlock(this);
	});
}
function connectRadiollLoad(){
	$(".connect-radio").each(function(){
		setConnectLineRadio(this);
	});
}

function connectBlock(eto){
	var idTo = $(eto).val();
	var isEmty = 0;
	var idFrom = $(eto).parents(".block-questions:first").attr("id");
	var indexFrom = $(eto).parents(".block-questions:first").data("blocknumber");
	
	/*console.log($(eto).parents(".block-questions:first"));
	console.log(idTo);
	console.log(indexFrom);
	console.log(idFrom);*/
	if(("blockid-" + idTo) == idFrom){
		alert("Соединение сам-на-себя. Не пойдёт");
		return true;
	}
	
	if(typeof idTo == "undefined" || idTo == null){
		isEmty = 1;
	}else{
		if(idTo.length === 0){
			isEmty = 1;
		}
	}
	
	if(isEmty === 1){//Очищаю старую линию если есть
		var size  = listLineObject.length;
		for(var iz=0; iz<size; iz++){
	
			if(listLineObject[iz].line.start.id == $(eto).parents(".block-questions:first").attr("id")){
				listLineObject[iz].line.hide();
				listLineObject.splice(iz, 1);
			}
		}
		return true;
	}
	var start = $(eto).parents(".block-questions:first")[0];
	var end = $("[data-blocknumber='" + idTo + "']")[0];
	if(typeof start == "undefined" || typeof end == "undefined"){
		alert("Не правильно указан стартовый  или конечный блок.(2)");
		return true;
	}
	
	$("[data-blocknumber='" + idTo + "']").data("indexfrom", indexFrom).attr("data-indexfrom", indexFrom);
	var line = new LeaderLine(start,end);
	line.color = 'rgba(30, 130, 250, 0.5)';
    line.setOptions({startSocket: 'bottom', endSocket: 'top'});
    line.path = 'straight';
	//line.path = 'grid';
	/*line.path = 'fluid';
	line.startSocketGravity = [-50,50];
	line.endSocketGravity = [10,-50]*/
	line.size = 3;
	//Сохраняю массив линий
	var size  = listLineObject.length;
	
	for(var iz=0; iz<size; iz++){
		if(listLineObject[iz].line.start.id == $(eto).parents(".block-questions:first").attr("id")){
			listLineObject[iz].line.hide();
			listLineObject.splice(iz, 1);//Если повтор старую линию удаляю
			size--;
		}
	}
	size  = listLineObject.length;
	listLineObject[size] = {};
	listLineObject[size] = {line};
	return true;
}
function setTextInputValue(eto){
	$(eto).attr("value", $(eto).val());
	return true;
}
function setRadioTitle(eto){
	$(eto).parents("label:first").find(".dev-radio-input").val($(eto).text());
	$(eto).parents("label:first").find(".dev-radio-input").attr("value", $(eto).text());
	return true;
}
function setRadioChecked(eto){
	if($(eto).prop("checked") === true){
		if(typeof $(eto).attr("checked") == "undefined"){
			$(eto).attr("checked", "checked");
		}
		$(eto).parents(".wrap-answers-radio:first").find(".dev-radio-input").each(function(){
			if($(eto).attr("id") == $(this).attr("id")){
			}else{
				$(this).removeAttr("checked");
			}
		});
	}else{
		if(typeof $(eto).attr("checked") != "undefined"){
			$(eto).removeAttr("checked");
		}
	}
	return true;
}
function deActivateChecked(eto){
	if($(eto).parents("label:first").find("input").prop("checked") === true){
		$(eto).parents("label:first").find("input").prop("checked", false);
		$(eto).parents("label:first").find("input").removeAttr("checked");
		return false;
	}
	return true;
}
/* ********************************************************** */
//Генерация формы для просмотра
function makeFormToPrevShow(number){
	var url = "/baform/ajax.php?dd=" + (new Date).getTime();
	var dataForm = [];
	//Собираю все данные
	var izBlock = 0;
	$(".block-questions").each(function(){//Цикл по блокам
		dataForm[izBlock] = {};
		var indexBlock = $(this).data("blocknumber");
		var questionText = $(this).find(".editable-question").text();
		var anwersRadio = [];
		var izRadio = 0;
		$(this).find('.wrap-answers-radio label').each(function(){//Цикл по радио кнопкам
			anwersRadio[izRadio] = {};
			var inputNameLatin = $(this).find("input").attr("name");
			var inputId = $(this).find("input").attr("id");
			var inputName = $(this).find("input").val();
			var inputChecked = $(this).find("input").prop("checked");
			if(inputChecked === true){
				inputChecked = 1;
			}else{
				inputChecked = 0;
			}
			var dataNumbeRadio = $(this).find("input").data("numberradio");
			var inputClass = $(this).find("input").attr("class");
			
			anwersRadio[izRadio].inputNameLatin = inputNameLatin;
			anwersRadio[izRadio].inputId = inputId;
			anwersRadio[izRadio].inputName = inputName;
			anwersRadio[izRadio].inputChecked = inputChecked;//Это для контроля вопросов для Экзамена верно/не верно (Пока в заготовке)
			anwersRadio[izRadio].dataNumbeRadio = dataNumbeRadio;
			anwersRadio[izRadio].inputClass = inputClass;
			anwersRadio[izRadio].answerConnectTo = $(this).find(".connect-radio").val();
			anwersRadio[izRadio].dataImage = $(this).find(".icon-img").attr("src");

			izRadio++;
		});
		dataForm[izBlock].indexBlock = indexBlock;
		dataForm[izBlock].questionText = questionText;
		dataForm[izBlock].anwersRadio = anwersRadio;
		var izInputText  = 0;
		var inputTextArr  = [];
		$(this).find('.dev-text-input').each(function(){//Цикл по строковым input полям
			inputTextArr[izInputText]  = {};
			inputTextArr[izInputText].dataNumberTextInput = $(this).data("numbertextinput");
			inputTextArr[izInputText].classTextInput = $(this).attr("class");
			inputTextArr[izInputText].nameTextInput = $(this).attr("name");
			inputTextArr[izInputText].iDTextInput = $(this).attr("id");
			inputTextArr[izInputText].valueTextInput = $(this).val();
			if($(this).hasClass("isemail")) {
				inputTextArr[izInputText].isemail = "Y";
			}else {
				inputTextArr[izInputText].isemail = "N";
			}

			if($(this).hasClass("isphone")) {
				inputTextArr[izInputText].isphone = "Y";
			}else {
				inputTextArr[izInputText].isphone = "N";
			}
			izInputText++;
		});
		dataForm[izBlock].inputTextArr = inputTextArr;
		dataForm[izBlock].freeTextField = $(this).find(".editable-free-text").html();
		
		dataForm[izBlock].buttonPrev = 0;
		if($(this).find(".prev-button").length>0){
			dataForm[izBlock].buttonPrev = 1;
		}
		
		dataForm[izBlock].buttonNext = 0;
		if($(this).find(".next-button").length>0){
			dataForm[izBlock].buttonNext = 1;
		}
		
		dataForm[izBlock].buttonSend = 0;
		if($(this).find(".send-button").length>0){
			dataForm[izBlock].buttonSend = 1;
		}
		dataForm[izBlock].files = 0;
		if($(this).find(".cls-file").length>0){
			dataForm[izBlock].files = 1;
		}
		
		dataForm[izBlock].blockConnectTo = $(this).find(".connect-block").val();
		dataForm[izBlock].blockConnectFrom = $(this).data("indexfrom");
		
		dataForm[izBlock].blockExistFieldRezult = "N";
		var existFieldRezult = $(this).find(".rezult-fill-form");
		if(existFieldRezult.length>0){
			dataForm[izBlock].blockExistFieldRezult = "Y";
		}

		dataForm[izBlock].radiorowcount = 2;
		if($(this).find(".count-row-number").length>0) {
			var countRow = $(this).find(".count-row-number").text();
			if(typeof countRow !== 'undefined' && countRow !== null) {
				if(countRow.length>0) {
					dataForm[izBlock].radiorowcount = countRow;
				}
			}
		}

		izBlock++;
	});
	/* *********************** */
	var fromEmail= $('.emailfrom').val();
	var emailto= $('.emailto').val();
	var subject_email_to_admin= $('.subject_email_to_admin').val();
	var subject_email_to_user= $('.subject_email_to_user').val();

	var send_to_user = "N";

	if($(".send_to_user").prop("checked") === true) {
		send_to_user = "Y";
	}
	var userEmailKeyField = "";
	if($(".dev-text-input.isemail:first").length>0) {
		userEmailKeyField = $(".dev-text-input.isemail:first").attr("name");
	}
	var userPhoneKeyField = "";
	if($(".dev-text-input.isphone:first").length>0) {
		userPhoneKeyField = $(".dev-text-input.isphone:first").attr("name");
	}
	/* *********************** ДЛя шаблона с анимацией */
	var template = $('.select-template').val();
	if(template == "animate_effects"){
		var globaEffectOut = window.globaEffectOut;
		var globaEffectIn = window.globaEffectIn;
		var globalSpeedDis = window.globalSpeedDis;
		var globalSpeedApp = window.globalSpeedApp;
		var globalDisApp = window.globalDisApp;
		var globalApp = window.globalApp;
		var zaderjkaApp = window.zaderjkaApp;
	}else{
		var globaEffectOut = "";
		var globaEffectIn = "";
		var globalSpeedDis = "";
		var globalSpeedApp = "";
		var globalDisApp = "";
		var globalApp = "";
		var zaderjkaApp = "";
	}

	$.ajax({
    url: url,
    type: "post",
	async: true,
    data: {
		action:"makeshow",
		dataForm:dataForm,
		number:number,
		fromEmail:fromEmail,
		emailto:emailto,
		subject_email_to_admin:subject_email_to_admin,
		subject_email_to_user:subject_email_to_user,
		send_to_user:send_to_user,
		template:template,
		userEmailKeyField:userEmailKeyField,
		userPhoneKeyField:userPhoneKeyField,
		
		globaEffectOut:globaEffectOut,
		globaEffectIn:globaEffectIn,
		globalSpeedDis:globalSpeedDis,
		globalSpeedApp:globalSpeedApp,
		globalDisApp:globalDisApp,
		globalApp:globalApp,
		zaderjkaApp:zaderjkaApp
	},
	success: function(responseData, textStatus, jqXHR) {
        total = responseData;
		//console.log(total);
		$(".td-cell-3-result").html(total);
		if(number == 1){
			window.location = "/baform/showrezulthtml/index.html";
		}
	},error: function (responseData, textStatus, errorThrown) {}}); 
	return true;
}

function testSendEmailButton() {
	var url = "/baform/ajax.php?dd=" + (new Date).getTime();
	var fromEmail= $('.emailfrom').val();
	var emailto= $('.emailto').val();
	$.ajax({
		url: url,
		type: "post",
		async: true,
		data: {action:"testemail", fromEmail:fromEmail, emailto:emailto},
		success: function(responseData, textStatus, jqXHR) {
			total = responseData;
			alert(total);
	},error: function (responseData, textStatus, errorThrown) {}});
	return true;
}

