<?
IncludeModuleLangFile(__FILE__);
class CAllAnimatedgraphics {
    /**
     * Набор функций для генерации css кода. Конструктора класса не содержит
     * Все параметры принимаются функциями
     * @var array $arParams
     */


    static $module_id = "directoriya.animatedgraphics";
    static function getStyle_start($param, $tpl,$flCss=0){
        /**
         * Стартовая функция. Вызывается компонентом
         * Параметры компонента
         * @var array $arParams
         * Название шаблона компонента
         * @var string $tpl
         */
        $ms_iz=Array();
        if(isset($param['ALL_BLOK'])){}else{$param['ALL_BLOK'] = "";}
        $param['ALL_BLOK'] = self::getAllblokForTpl($param['ALL_BLOK'],$param,$tpl);
        if($flCss === 1) {
            $ms_iz[0] = self::generateHelpCss();
        }else {
            $ms_iz = self::prepareMs($param);
        }
        $out = "";
        $total_co=0;
        $i_pic=0;
        $str_persp="";
        $fl_dop_style = 0;
        foreach($ms_iz[0] as $class=>$val) {
            $class = html_entity_decode($class,ENT_QUOTES,LANG_CHARSET);/*Fix 20-03-2022*/
            $i_pic++;
            $out = $out.$class."{\r\n";
            $fl_dop_style = 0;
            if($fl_dop_style === 0) {
                foreach ($val as $vdop) {
                    if (isset($vdop['DOP_STYLE'])) { /* Update 23-03-2022 New filed for dop style string */
                        if (strlen($vdop['DOP_STYLE']) > 0) {
                            $out = $out . $vdop['DOP_STYLE'] . ";\r\n";
                            $fl_dop_style = 1;
                            break;
                        }
                    }
                }
            }
            $out = $out ."transform-origin: 50% 50%;\r\n-webkit-transform-origin: 50% 50%;\r\n-moz-transform-origin: 50% 50%;\r\n-o-transform-origin: 50% 50%;\r\n-ms-transform-origin: 50% 50%;";
            $str_1="";
            $str_2="";
            $str_3="";
            $str_4="";
            $str_5="";
            $fr_1="";
            $fr_2="";
            $fr_3="";
            $fr_4="";
            $fr_5="";
            $i_anim=0;
            $i_fr=0;
            $opacity_itog="";
            foreach($val as $val_2) {
                $sposob = 'linear';
                /*Одиночные эффекты*/
                $fl_once_eff=0;
                if(isset($val_2['SINGLE_EFFECT_CH'])) {
                    if($val_2['SINGLE_EFFECT_CH']=="Y") {
                        $fl_once_eff=1;
                    }
                }
                /**/
                if(isset($val_2['EFFECT']) && $fl_once_eff === 0) {
                    if($val_2['EFFECT'] == 'rotate_repspective_x_1' || $val_2['EFFECT'] == 'rotate_repspective_x_2' || $val_2['EFFECT'] == 'rotate_repspective_y_1' || $val_2['EFFECT'] == 'rotate_repspective_y_2'){
                        if(strlen($val_2['PARENT_ID'])>0) {
                            $str_persp = $str_persp . $val_2['PARENT_ID'] . "{-webkit-perspective-origin: 50% 50%;  
                                  perspective-origin: 50% 50%;  
                                  -webkit-transform-style: preserve-3d;  
                                  transform-style: preserve-3d;
                                  -webkit-perspective: 500px;
                                  perspective: 500px;}";
                        }
                    }
                }

                $total_co++;
                $i_fr++;
                $i_anim++;
                $infinite = self::getInfinite($val_2['STOP_COUNT'],$val_2['EFFECT'],$val_2);
                $zad = self::getZad($val_2['START_ZADERJKA']);
                $speed = self::getSpeed($val_2['SPEED']);
                $opacity = self::getOpasity($val_2['EFFECT']);
                if(strlen($opacity)>0 && $fl_once_eff === 0) {
                    $opacity_itog=$opacity;
                }
                if($fl_once_eff === 1) {
                    $msOnce = self::getOpasityOnceEffect($val_2['SINGLE_EFFECT_LIST'],$infinite);
                    $opacity_itog=$msOnce['opa'];
                    $sposob=$msOnce['sposob'];
                    $infinite = $msOnce['infinite'];
                }

                if(strlen($str_1) === 0) {
                    $str_1 = "\r\nanimation: " . $param['PREFIX_CLASS'] . "Frame_" . $i_fr . "_pic_" . $i_pic . "_Ani" . $i_anim . " ".$sposob." " . $speed . "s " . $zad . "s " . $infinite;
                }else {
                    $str_1 = $str_1 . ", " . $param['PREFIX_CLASS'] . "Frame_" . $i_fr . "_pic_" . $i_pic . "_Ani" . $i_anim . " ".$sposob." " . $speed . "s " . $zad . "s " . $infinite;
                }
                $fr_1 =$fr_1.self::getFrameEffectBr1($param['PREFIX_CLASS']."Frame_".$i_fr."_pic_".$i_pic."_Ani".$i_anim, $val_2['EFFECT'],$val_2);

                $i_anim++;
                if(strlen($str_2) === 0) {
                    $str_2 = "\r\n-webkit-animation: ".$param['PREFIX_CLASS']."Frame_".$i_fr."_pic_".$i_pic."_Ani".$i_anim." ".$sposob." ".$speed."s ".$zad."s ".$infinite;
                }else {
                    $str_2 = $str_2.", ".$param['PREFIX_CLASS']."Frame_".$i_fr."_pic_".$i_pic."_Ani".$i_anim." ".$sposob." ".$speed."s ".$zad."s ".$infinite;
                }
                $fr_2 = $fr_2.self::getFrameEffectBr2($param['PREFIX_CLASS']."Frame_".$i_fr."_pic_".$i_pic."_Ani".$i_anim, $val_2['EFFECT'],$val_2);

                $i_anim++;
                if(strlen($str_3) === 0) {
                    $str_3 = "\r\n-moz-animation: ".$param['PREFIX_CLASS']."Frame_".$i_fr."_pic_".$i_pic."_Ani".$i_anim." ".$sposob." ".$speed."s ".$zad."s ".$infinite;
                }else {
                    $str_3 = $str_3.", ".$param['PREFIX_CLASS']."Frame_".$i_fr."_pic_".$i_pic."_Ani".$i_anim." ".$sposob." ".$speed."s ".$zad."s ".$infinite;
                }
                $fr_3 = $fr_3.self::getFrameEffectBr3($param['PREFIX_CLASS']."Frame_".$i_fr."_pic_".$i_pic."_Ani".$i_anim, $val_2['EFFECT'],$val_2);

                $i_anim++;
                if(strlen($str_4) === 0) {
                    $str_4 = "\r\n-o-animation: ".$param['PREFIX_CLASS']."Frame_".$i_fr."_pic_".$i_pic."_Ani".$i_anim." ".$sposob." ".$speed."s ".$zad."s ".$infinite;
                }else {
                    $str_4 = $str_4.", ".$param['PREFIX_CLASS']."Frame_".$i_fr."_pic_".$i_pic."_Ani".$i_anim." ".$sposob." ".$speed."s ".$zad."s ".$infinite;
                }
                $fr_4 = $fr_4.self::getFrameEffectBr4($param['PREFIX_CLASS']."Frame_".$i_fr."_pic_".$i_pic."_Ani".$i_anim, $val_2['EFFECT'],$val_2);

                $i_anim++;
                if(strlen($str_5) === 0) {
                    $str_5 = "\r\n-ms-animation: ".$param['PREFIX_CLASS']."Frame_".$i_fr."_pic_".$i_pic."_Ani".$i_anim." ".$sposob." ".$speed."s ".$zad."s ".$infinite;
                }else {
                    $str_5 = $str_5.", ".$param['PREFIX_CLASS']."Frame_".$i_fr."_pic_".$i_pic."_Ani".$i_anim." ".$sposob." ".$speed."s ".$zad."s ".$infinite;
                }
                $fr_5 = $fr_5.self::getFrameEffectBr5($param['PREFIX_CLASS']."Frame_".$i_fr."_pic_".$i_pic."_Ani".$i_anim, $val_2['EFFECT'],$val_2);

            }
            $str_1 = $str_1.";\r\n";
            $str_2 = $str_2.";\r\n";
            $str_3 = $str_3.";\r\n";
            $str_4 = $str_4.";\r\n";
            if(strlen($opacity_itog)>0) {
                $str_4=$str_4."\r\n".$opacity_itog."\r\n";
            }
            $str_5 = $str_5.";\r\n}\r\n";
            $out = $out.$str_1.$str_2.$str_3.$str_4.$str_5.$fr_1.$fr_2.$fr_3.$fr_4.$fr_5;
        }
        $out = $str_persp.$out;
        return $out;

    }
    static function  getFrameEffectBr5($frName,$eff,$fullMs) {
        /**
         * Для MS Explorer(Ege)
         *Имя css селектора анимационного фрэйма
         * @var string $frName
         * css ИД эффекта для генерации css кода анимационного фрэйма
         * @var string $eff
         */
        if(isset($fullMs['SINGLE_EFFECT_CH'])) {
            if($fullMs['SINGLE_EFFECT_CH'] == "Y") {
                $out="\r\n@keyframes ".$frName."{\r\n";
                $out = $out.self::getOnceEffectLib($fullMs, 5);
                $out = $out."\r\n}\r\n";
                return $out;
            }
        }
        $out="\r\n@-ms-keyframes ".$frName."{\r\n";
        if($eff == 'opacity_up') {
            $out=$out.'0% {
                    opacity:0;
                    }
                    100% {
                    opacity:1;
                    }
            ';
        }
        if($eff == 'opacity_down') {
            $out=$out.'0% {
                    opacity:1;
                    }
                    100% {
                    opacity:0;
                    }
            ';
        }
        if($eff == 'bg_left') {

            $out=$out.'0% {
                    background-position-x: 0%;
                    }
                    100% {
                    background-position-x: 200%;
                    }
            ';
        }
        if($eff == 'bg_right') {
            $out=$out.'0% {
                    background-position-x: 0%;
                    }
                    100% {
                    background-position-x: -100%;
                    }
            ';
        }
        if($eff == 'telefon') {
            $out=$out.self::getOneTelefonEffect('-ms-transform');
        }
        /* Совмещенные эффекты transform */
        if($eff <> 'telefon' && strpos($eff,'telefon')!==false) {
            $out = $out.self::getComplexEffectTranform('-ms-transform',$eff);
        }else {
            $ms_s = self::get_implodeEffect();
            $iz = 0;
            $str1 = "";
            $str2 = "";
            $str3 = "";
            foreach ($ms_s as $key => $val) {
                if (strpos($eff, $key) !== false) {
                    $iz++;
                    $str1 = $str1 . " " . $val[0] . $val[1];
                    $str2 = $str2 . " " . $val[0] . $val[3];
                    $str3 = $str3 . " " . $val[0] . $val[2];
                }
            }
            if ($iz > 0) {
                $out = $out . '0% {
                    -ms-transform: ' . $str1 . ';
                }
                50% {
                    -ms-transform:  ' . $str2 . ';
                }
                100% {
                    -ms-transform:  ' . $str3 . ';
                }
            ';
            }
        }
        /* ПРозрачность цикличная */
        if($eff == 'opacity_up_mnogo') {
            $out=$out.'0% {
                    opacity:0;
                    }
                    50% {
                    opacity:1;
                    }
                    100% {
                    opacity:0;
                    }
            ';
        }
        if($eff == 'opacity_down_mnogo') {
            $out=$out.'0% {
                    opacity:1;
                    }
                    50% {
                    opacity:0;
                    }
                    100% {
                    opacity:1;
                    }
            ';
        }
        if($eff == 'wolna_eff') {
            $rgb = self::hexToRgb($fullMs['COLOR_ID']);
            $fl_volna=0;
            if(isset($fullMs['VOLNA_OPASITY_CH'])) {
                if($fullMs['VOLNA_OPASITY_CH'] == "Y") {
                    $fl_volna=1;/* Высокая прозрачность волны */
                }
            }
            if($fl_volna === 1) {
                $out = $out . '0% {
                -webkit-box-shadow:0 8px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.3),0 0 0 0 rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.2),0 0 0 0 rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.2);
                }
                40% {
                    -webkit-box-shadow:0 8px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.3),0 0 0 15px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.2),0 0 0 0 rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.2);
                }
                80% {
                    -webkit-box-shadow:0 8px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.3),0 0 0 30px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0),0 0 0 26.7px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.067);
                }
                100% {
                    -webkit-box-shadow:0 8px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.3),0 0 0 30px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0),0 0 0 40px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.0);
                }
                ';
            }else {

                $out = $out . '0% {
                    -webkit-box-shadow:0 0px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.98),0 0 0 0 rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.7),0 0 0 0 rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.7);
                }
                40% {
                    -webkit-box-shadow:0 0px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.98),0 0 0 15px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.7),0 0 0 0 rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.7);
                }
                80% {
                    -webkit-box-shadow:0 0px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.98),0 0 0 30px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0),0 0 0 26.7px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.3);
                }
                100% {
                    -webkit-box-shadow:0 0px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.98),0 0 0 30px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0),0 0 0 40px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.0);
                }
                ';

            }
        }
        /**/

        $out = $out."\r\n}\r\n";
        return $out;
    }
    static function  getFrameEffectBr4($frName,$eff,$fullMs) {
        /**
         * Для Opera
         *Имя css селектора анимационного фрэйма
         * @var string $frName
         * css ИД эффекта для генерации css кода анимационного фрэйма
         * @var string $eff
         */
        if(isset($fullMs['SINGLE_EFFECT_CH'])) {
            if($fullMs['SINGLE_EFFECT_CH'] == "Y") {
                $out="\r\n@keyframes ".$frName."{\r\n";
                $out = $out.self::getOnceEffectLib($fullMs, 4);
                $out = $out."\r\n}\r\n";
                return $out;
            }
        }
        $out="\r\n@-o-keyframes ".$frName."{\r\n";
        if($eff == 'opacity_up') {
            $out=$out.'0% {
                    opacity:0;
                    }
                    100% {
                    opacity:1;
                    }
            ';
        }
        if($eff == 'opacity_down') {
            $out=$out.'0% {
                    opacity:1;
                    }
                    100% {
                    opacity:0;
                    }
            ';
        }
        if($eff == 'bg_left') {

            $out=$out.'0% {
                        background-position-x: 0%;
                    }
                    100% {
                        background-position-x: 200%;
                    }
            ';
        }
        if($eff == 'bg_right') {
            $out=$out.'0% {
                        background-position-x: 0%;
                    }
                    100% {
                        background-position-x: -100%;
                    }
            ';
        }
        if($eff == 'telefon') {
            $out=$out.self::getOneTelefonEffect('-o-transform');
        }
        /* Совмещенные эффекты transform */
        if($eff <> 'telefon' && strpos($eff,'telefon')!==false) {
            $out = $out.self::getComplexEffectTranform('-o-transform',$eff);
        }else {
            $ms_s = self::get_implodeEffect();
            $iz = 0;
            $str1 = "";
            $str2 = "";
            $str3 = "";
            foreach ($ms_s as $key => $val) {
                if (strpos($eff, $key) !== false) {
                    $iz++;
                    $str1 = $str1 . " " . $val[0] . $val[1];
                    $str2 = $str2 . " " . $val[0] . $val[3];
                    $str3 = $str3 . " " . $val[0] . $val[2];
                }
            }
            if ($iz > 0) {
                $out = $out . '0% {
                    -o-transform: ' . $str1 . ';
                }
                50% {
                    -o-transform:  ' . $str2 . ';
                }
                100% {
                    -o-transform:  ' . $str3 . ';
                }
            ';
            }
        }
        /* ПРозрачность цикличная */
        if($eff == 'opacity_up_mnogo') {
            $out=$out.'0% {
                    opacity:0;
                    }
                    50% {
                    opacity:1;
                    }
                    100% {
                    opacity:0;
                    }
            ';
        }
        if($eff == 'opacity_down_mnogo') {
            $out=$out.'0% {
                    opacity:1;
                    }
                    50% {
                    opacity:0;
                    }
                    100% {
                    opacity:1;
                    }
            ';
        }
        /**/
        if($eff == 'wolna_eff') {
            $rgb = self::hexToRgb($fullMs['COLOR_ID']);
            $fl_volna=0;
            if(isset($fullMs['VOLNA_OPASITY_CH'])) {
                if($fullMs['VOLNA_OPASITY_CH'] == "Y") {
                    $fl_volna=1;/* Высокая прозрачность волны */
                }
            }
            if($fl_volna === 1) {
                $out = $out . '0% {
                -webkit-box-shadow:0 8px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.3),0 0 0 0 rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.2),0 0 0 0 rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.2);
                }
                40% {
                    -webkit-box-shadow:0 8px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.3),0 0 0 15px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.2),0 0 0 0 rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.2);
                }
                80% {
                    -webkit-box-shadow:0 8px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.3),0 0 0 30px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0),0 0 0 26.7px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.067);
                }
                100% {
                    -webkit-box-shadow:0 8px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.3),0 0 0 30px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0),0 0 0 40px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.0);
                }
                ';
            }else {
                $out = $out . '0% {
                -webkit-box-shadow:0 0px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.98),0 0 0 0 rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.7),0 0 0 0 rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.7);
                }
                40% {
                    -webkit-box-shadow:0 0px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.98),0 0 0 15px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.7),0 0 0 0 rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.7);
                }
                80% {
                    -webkit-box-shadow:0 0px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.98),0 0 0 30px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0),0 0 0 26.7px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.3);
                }
                100% {
                    -webkit-box-shadow:0 0px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.98),0 0 0 30px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0),0 0 0 40px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.0);
                }
                ';
            }
        }
        $out = $out."\r\n}\r\n";
        return $out;
    }
    static function  getFrameEffectBr3($frName,$eff,$fullMs) {
        /**
         * Для Mozilla
         *Имя css селектора анимационного фрэйма
         * @var string $frName
         * css ИД эффекта для генерации css кода анимационного фрэйма
         * @var string $eff
         */
        if(isset($fullMs['SINGLE_EFFECT_CH'])) {
            if($fullMs['SINGLE_EFFECT_CH'] == "Y") {
                $out="\r\n@keyframes ".$frName."{\r\n";
                $out = $out.self::getOnceEffectLib($fullMs, 3);
                $out = $out."\r\n}\r\n";
                return $out;
            }
        }
        $out="\r\n@-moz-keyframes ".$frName."{\r\n";
        if($eff == 'opacity_up') {
            $out=$out.'0% {
                    opacity:0;
                    }
                    100% {
                    opacity:1;
                    }
            ';
        }
        if($eff == 'opacity_down') {
            $out=$out.'0% {
                    opacity:1;
                    }
                    100% {
                    opacity:0;
                    }
            ';
        }
        if($eff == 'bg_left') {

            $out=$out.'0% {
                    background-position-x: 0%;
                    }
                    100% {
                    background-position-x: 200%;
                    }
            ';
        }
        if($eff == 'bg_right') {
            $out=$out.'0% {
                        background-position-x: 0%;
                    }
                    100% {
                        background-position-x: -100%;
                    }
            ';
        }
        if($eff == 'telefon') {
            $out=$out.self::getOneTelefonEffect('-moz-transform');
        }
        /* Совмещенные эффекты transform */
        if($eff <> 'telefon' && strpos($eff,'telefon')!==false) {
            $out = $out.self::getComplexEffectTranform('-moz-transform',$eff);
        }else {
            $ms_s = self::get_implodeEffect();
            $iz = 0;
            $str1 = "";
            $str2 = "";
            $str3 = "";
            foreach ($ms_s as $key => $val) {
                if (strpos($eff, $key) !== false) {
                    $iz++;
                    $str1 = $str1 . " " . $val[0] . $val[1];
                    $str2 = $str2 . " " . $val[0] . $val[3];
                    $str3 = $str3 . " " . $val[0] . $val[2];
                }
            }
            if ($iz > 0) {
                $out = $out . '0% {
                    -moz-transform: ' . $str1 . ';
                }
                50% {
                    -moz-transform:  ' . $str2 . ';
                }
                100% {
                    -moz-transform:  ' . $str3 . ';
                }
            ';
            }
        }
        /* ПРозрачность цикличная */
        if($eff == 'opacity_up_mnogo') {
            $out=$out.'0% {
                    opacity:0;
                    }
                    50% {
                    opacity:1;
                    }
                    100% {
                    opacity:0;
                    }
            ';
        }
        if($eff == 'opacity_down_mnogo') {
            $out=$out.'0% {
                    opacity:1;
                    }
                    50% {
                    opacity:0;
                    }
                    100% {
                    opacity:1;
                    }
            ';
        }
        if($eff == 'wolna_eff') {
            $rgb = self::hexToRgb($fullMs['COLOR_ID']);
            $fl_volna=0;
            if(isset($fullMs['VOLNA_OPASITY_CH'])) {
                if($fullMs['VOLNA_OPASITY_CH'] == "Y") {
                    $fl_volna=1;/* Высокая прозрачность волны */
                }
            }
            if($fl_volna === 1) {
                $out = $out . '0% {
                -moz-box-shadow:0 8px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.3),0 0 0 0 rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.2),0 0 0 0 rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.2);
                }
                40% {
                    -moz-box-shadow:0 8px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.3),0 0 0 15px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.2),0 0 0 0 rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.2);
                }
                80% {
                    -moz-box-shadow:0 8px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.3),0 0 0 30px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0),0 0 0 26.7px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.067);
                }
                100% {
                    -moz-box-shadow:0 8px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.3),0 0 0 30px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0),0 0 0 40px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.0);
                }
                ';
            }else {
                $out = $out . '0% {
                    -moz-box-shadow:0 0px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.98),0 0 0 0 rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.7),0 0 0 0 rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.7);
                }
                40% {
                    -moz-box-shadow:0 0px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.98),0 0 0 15px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.7),0 0 0 0 rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.7);
                }
                80% {
                    -moz-box-shadow:0 0px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.98),0 0 0 30px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0),0 0 0 26.7px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.3);
                }
                100% {
                    -moz-box-shadow:0 0px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.98),0 0 0 30px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0),0 0 0 40px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.0);
                }
                ';

            }
        }
        /**/
        $out = $out."\r\n}\r\n";
        return $out;
    }
    static function  getFrameEffectBr2($frName,$eff,$fullMs) {
        /**
         * Для Chrome
         *Имя css селектора анимационного фрэйма
         * @var string $frName
         * css ИД эффекта для генерации css кода анимационного фрэйма
         * @var string $eff
         */
        if(isset($fullMs['SINGLE_EFFECT_CH'])) {
            if($fullMs['SINGLE_EFFECT_CH'] == "Y") {
                $out="\r\n@keyframes ".$frName."{\r\n";
                $out = $out.self::getOnceEffectLib($fullMs, 2);
                $out = $out."\r\n}\r\n";
                return $out;
            }
        }
        $out="\r\n@-webkit-keyframes ".$frName."{\r\n";
        if($eff == 'opacity_up') {
            $out=$out.'0% {
                    opacity:0;
                    }
                    100% {
                    opacity:1;
                    }
            ';
        }
        if($eff == 'opacity_down') {
            $out=$out.'0% {
                    opacity:1;
                    }
                    100% {
                    opacity:0;
                    }
            ';
        }
        if($eff == 'bg_left') {

            $out=$out.'0% {
                    background-position-x: 0%;
                    }
                    100% {
                    background-position-x: 200%;
                    }
            ';
        }
        if($eff == 'bg_right') {
            $out=$out.'0% {
                    background-position-x: 0%;
                    }
                    100% {
                    background-position-x: -100%;
                    }
            ';
        }
        if($eff == 'telefon') {
            $out=$out.self::getOneTelefonEffect('-webkit-transform');
        }
        /* Совмещенные эффекты transform */
        if($eff <> 'telefon' && strpos($eff,'telefon')!==false) {
            $out = $out.self::getComplexEffectTranform('-webkit-transform',$eff);
        }else {
            $ms_s = self::get_implodeEffect();
            $iz = 0;
            $str1 = "";
            $str2 = "";
            $str3 = "";

            foreach ($ms_s as $key => $val) {

                if (strpos($eff, $key) !== false) {
                    $iz++;
                    $str1 = $str1 . " " . $val[0] . $val[1];
                    $str2 = $str2 . " " . $val[0] . $val[3];
                    $str3 = $str3 . " " . $val[0] . $val[2];

                }
            }

            if ($iz > 0) {

                $out = $out . '0% {
                    -webkit-transform: ' . $str1 . ';
                }
                50% {
                    -webkit-transform:  ' . $str2 . ';
                }
                100% {
                    -webkit-transform:  ' . $str3 . ';
                }
            ';
            }
        }
        /* ПРозрачность цикличная */
        if($eff == 'opacity_up_mnogo') {
            $out=$out.'0% {
                    opacity:0;
                    }
                    50% {
                    opacity:1;
                    }
                    100% {
                    opacity:0;
                    }
            ';
        }
        if($eff == 'opacity_down_mnogo') {
            $out=$out.'0% {
                    opacity:1;
                    }
                    50% {
                    opacity:0;
                    }
                    100% {
                    opacity:1;
                    }
            ';
        }
        if($eff == 'wolna_eff') {
            $rgb = self::hexToRgb($fullMs['COLOR_ID']);
            $fl_volna=0;
            if(isset($fullMs['VOLNA_OPASITY_CH'])) {
                if($fullMs['VOLNA_OPASITY_CH'] == "Y") {
                    $fl_volna=1;/* Высокая прозрачность волны */
                }
            }
            if($fl_volna === 1) {
                $out = $out . '0% {
                -webkit-box-shadow:0 8px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.3),0 0 0 0 rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.2),0 0 0 0 rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.2);
                }
                40% {
                    -webkit-box-shadow:0 8px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.3),0 0 0 15px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.2),0 0 0 0 rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.2);
                }
                80% {
                    -webkit-box-shadow:0 8px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.3),0 0 0 30px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0),0 0 0 26.7px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.067);
                }
                100% {
                    -webkit-box-shadow:0 8px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.3),0 0 0 30px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0),0 0 0 40px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.0);
                }
                ';
            }else {
                $out = $out . '0% {
                    -webkit-box-shadow:0 0px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.98),0 0 0 0 rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.7),0 0 0 0 rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.7);
                }
                40% {
                    -webkit-box-shadow:0 0px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.98),0 0 0 15px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.7),0 0 0 0 rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.7);
                }
                80% {
                    -webkit-box-shadow:0 0px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.98),0 0 0 30px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0),0 0 0 26.7px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.3);
                }
                100% {
                    -webkit-box-shadow:0 0px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.98),0 0 0 30px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0),0 0 0 40px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.0);
                }
                ';

            }
        }


        $out = $out."\r\n}\r\n";
        return $out;
    }

    static function  getFrameEffectBr1($frName,$eff,$fullMs) {
        /**
         * Для Chrome и универсально для любых других
         *Имя css селектора анимационного фрэйма
         * @var string $frName
         * css ИД эффекта для генерации css кода анимационного фрэйма
         * @var string $eff
         */
        if(isset($fullMs['SINGLE_EFFECT_CH'])) {
            if($fullMs['SINGLE_EFFECT_CH'] == "Y") {
                $out="\r\n@keyframes ".$frName."{\r\n";
                $out = $out.self::getOnceEffectLib($fullMs, 1);
                $out = $out."\r\n}\r\n";
                return $out;
            }
        }
        $out="\r\n@keyframes ".$frName."{\r\n";
        if($eff == 'opacity_up') {
            $out=$out.'0% {
                    opacity:0;
                    }
                    100% {
                    opacity:1;
                    }
            ';
        }
        if($eff == 'opacity_down') {
            $out=$out.'0% {
                    opacity:1;
                    }
                    100% {
                    opacity:0;
                    }
            ';
        }
        if($eff == 'bg_left') {

            $out=$out.'0% {
                        background-position-x: 0%;
                    }
                    100% {
                        background-position-x: 200%;
                    }
            ';
        }
        if($eff == 'bg_right') {
            $out=$out.'0% {
                        background-position-: 0%;
                    }
                    100% {
                        background-position-x: -100%;
                    }
            ';
        }
        if($eff == 'telefon') {
            $out=$out.self::getOneTelefonEffect('transform');
        }
        /* Совмещенные эффекты transform */
        if($eff <> 'telefon' && strpos($eff,'telefon')!==false) {
            $out = $out.self::getComplexEffectTranform('transform',$eff);
        }else {
            $ms_s = self::get_implodeEffect();
            $iz = 0;
            $str1 = "";
            $str2 = "";
            $str3 = "";
            foreach ($ms_s as $key => $val) {
                if (strpos($eff, $key) !== false) {
                    $iz++;
                    $str1 = $str1 . " " . $val[0] . $val[1];
                    $str2 = $str2 . " " . $val[0] . $val[3];
                    $str3 = $str3 . " " . $val[0] . $val[2];
                }
            }

            if ($iz > 0) {
                $out = $out . '0% {
                        transform: ' . $str1 . ';
                    }
                    50% {
                        transform:  ' . $str2 . ';
                    }
                    100% {
                        transform:  ' . $str3 . ';
                    }
                ';
            }
        }
        /* ПРозрачность цикличная */
        if($eff == 'opacity_up_mnogo') {
            $out=$out.'0% {
                    opacity:0;
                    }
                    50% {
                    opacity:1;
                    }
                    100% {
                    opacity:0;
                    }
            ';
        }
        if($eff == 'opacity_down_mnogo') {
            $out=$out.'0% {
                    opacity:1;
                    }
                    50% {
                    opacity:0;
                    }
                    100% {
                    opacity:1;
                    }
            ';
        }
        /*Волна*/
        /*wolna_eff*/
        if($eff == 'wolna_eff') {
            $rgb = self::hexToRgb($fullMs['COLOR_ID']);
            $fl_volna=0;
            if(isset($fullMs['VOLNA_OPASITY_CH'])) {
                if($fullMs['VOLNA_OPASITY_CH'] == "Y") {
                    $fl_volna=1;/* Высокая прозрачность волны */
                }
            }
            if($fl_volna === 1) {
                $out = $out . '0% {
                box-shadow:0 0px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.3),0 0 0 0 rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.2),0 0 0 0 rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.2);
            }
            40% {
                box-shadow:0 0px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.3),0 0 0 15px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.2),0 0 0 0 rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.2);
            }
            80% {
                box-shadow:0 0px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.3),0 0 0 30px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0),0 0 0 26.7px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.067);
            }
            100% {
                box-shadow:0 0px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.3),0 0 0 30px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0),0 0 0 40px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.0);
            }
            ';
            }else {
                $out = $out . '0% {
                    box-shadow:0 0px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.98),0 0 0 0 rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.7),0 0 0 0 rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.7);
                }
                40% {
                    box-shadow:0 0px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.98),0 0 0 15px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.7),0 0 0 0 rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.7);
                }
                80% {
                    box-shadow:0 0px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.98),0 0 0 30px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0),0 0 0 26.7px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.3);
                }
                100% {
                    box-shadow:0 0px 10px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.98),0 0 0 30px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0),0 0 0 40px rgba(' . $rgb['r'] . ',' . $rgb['g'] . ',' . $rgb['b'] . ',0.0);
                }
                ';
            }


        }

        $out = $out."\r\n}\r\n";
        return $out;
    }

    static function  getOpasityOnceEffect($str,$infinite){
        $out=Array();
        $out['opa']="";
        $out['sposob']='linear';
        $out['infinite']=$infinite;
        if($str == 'speedin') {
            $out['sposob']='ease-out';
        }
        if($str == 'flip1') {
            $out['opa'] = "opacity:1;";
        }
        $msForwards = self::getGruppEffect();
        if( (in_array($str,$msForwards["entrance"]["CODE_EFF"]) || in_array($str,$msForwards["exit"]["CODE_EFF"])) &&  COption::GetOptionString('directoriya.animatedgraphics', 'stop_once_anim_force_forwards') == "Y") {
            $out['infinite'] = "1 forwards";
        }
        return $out;
    }
    static function getOnceEffectLib($fullMs,$n) {
        $timing = '-webkit-animation-timing-function';
        $transition_timing = 'transition-timing-function';
        $transform_origin = 'transform-origin';
        if($n == 1) {
            $tr='transform';
            $timing = 'animation-timing-function';
            $transition_timing = 'transition-timing-function';
            $transform_origin = 'transform-origin';
        }
        if($n == 2) {
            $tr='-webkit-transform';
            $transition_timing = '-webkit-transition-timing-function';
            $transform_origin = '-webkit-transform-origin';
        }
        if($n == 3) {
            $tr='-moz-transform';
            $timing = '-moz-animation-timing-function';
            $transition_timing = '-moz-transition-timing-function';
            $transform_origin = '-moz-transform-origin';
        }
        if($n == 4) {
            $tr='-o-transform';
            $transition_timing = '-o-transition-timing-function';
            $transform_origin = '-o-transform-origin';
        }
        if($n == 5) {
            $tr='-ms-transform';
            $transform_origin = '-ms-transform-origin';
        }
        /**/
        if($fullMs['SINGLE_EFFECT_LIST'] == 'swirloutbcktop') {
            $out='
               0% {
                    opacity: 1;
                    '.$tr.': rotate(0) scale(1);
                    '.$transform_origin.': 50% 0;
                  }
                
                  100% {
                    opacity: 0;
                    '.$tr.': rotate(-540deg) scale(0);
                    '.$transform_origin.': 50% 0;
                  }
            ';
        }
        if($fullMs['SINGLE_EFFECT_LIST'] == 'swirloutbckright') {
            $out='
               0% {
            opacity: 1;
            '.$tr.': rotate(0) scale(1);
            '.$transform_origin.': 100% 50%;
          }
        
          100% {
            opacity: 0;
            '.$tr.': rotate(-540deg) scale(0);
            '.$transform_origin.': 100% 50%;
          }
            ';
        }
        if($fullMs['SINGLE_EFFECT_LIST'] == 'swirloutbckleft') {
            $out='
               0% {
                opacity: 1;
                '.$tr.': rotate(0) scale(1);
                '.$transform_origin.': 0 50%;
              }
            
              100% {
                opacity: 0;
                '.$tr.': rotate(-540deg) scale(0);
                '.$transform_origin.': 0 50%;
              }
            ';
        }
        if($fullMs['SINGLE_EFFECT_LIST'] == 'swirloutbckcenter') {
            $out='
               0% {
                opacity: 1;
                '.$tr.': rotate(0) scale(1);
              }
            
              100% {
                opacity: 0;
                '.$tr.': rotate(-540deg) scale(0);
              }
            ';
        }
        if($fullMs['SINGLE_EFFECT_LIST'] == 'swirloutbckbottom') {
            $out='
               0% {
                opacity: 1;
                '.$tr.': rotate(0) scale(1);
                '.$transform_origin.': 50% 100%;
              }
            
              100% {
                opacity: 0;
                '.$tr.': rotate(-540deg) scale(0);
                '.$transform_origin.': 50% 100%;
              }
            ';
        }
        if($fullMs['SINGLE_EFFECT_LIST'] == 'swirloutfwdtop') {
            $out='
               0% {
                opacity: 1;
                '.$tr.': rotate(0) scale(1);
                '.$transform_origin.': 50% 0;
              }
            
              100% {
                opacity: 0;
                '.$tr.': rotate(-540deg) scale(2);
                '.$transform_origin.': 50% 0;
              }
            ';
        }
        if($fullMs['SINGLE_EFFECT_LIST'] == 'swirloutfwdright') {
            $out='
               0% {
                opacity: 1;
                '.$tr.': rotate(0) scale(1);
                '.$transform_origin.': 100% 50%;
              }
            
              100% {
                opacity: 0;
                '.$tr.': rotate(-540deg) scale(2);
                '.$transform_origin.': 100% 50%;
              }
            ';
        }
        if($fullMs['SINGLE_EFFECT_LIST'] == 'swirloutfwdleft') {
            $out='
               0% {
                opacity: 1;
                '.$tr.': rotate(0) scale(1);
                '.$transform_origin.': 0 50%;
              }
            
              100% {
                opacity: 0;
                '.$tr.': rotate(-540deg) scale(2);
                '.$transform_origin.': 0 50%;
              }
            ';
        }
        if($fullMs['SINGLE_EFFECT_LIST'] == 'swirloutfwdcenter') {
            $out='
               0% {
                opacity: 1;
                '.$tr.': rotate(0) scale(1);
              }
            
              100% {
                opacity: 0;
                '.$tr.': rotate(-540deg) scale(2);
              }
            ';
        }
        if($fullMs['SINGLE_EFFECT_LIST'] == 'swirloutfwd') {
            $out='
               0% {
                opacity: 1;
                '.$tr.': rotate(0) scale(1);
                '.$transform_origin.': 50% 100%;
              }
            
              100% {
                opacity: 0;
                '.$tr.': rotate(-540deg) scale(2);
                '.$transform_origin.': 50% 100%;
              }
            ';
        }
        if($fullMs['SINGLE_EFFECT_LIST'] == 'rotateoutupright') {
            $out='
               0% {
              '.$transform_origin.': right bottom;
              opacity: 1;
              }
              100% {
              '.$transform_origin.': right bottom;
              '.$tr.': rotate3d(0, 0, 1, 90deg);
              opacity: 0;
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'rotateoutupleft') {
            $out='
               0% {
              '.$transform_origin.': left bottom;
              opacity: 1;
              }
              100% {
              '.$transform_origin.': left bottom;
              '.$tr.': rotate3d(0, 0, 1, -45deg);
              opacity: 0;
              }
            ';
        }
        if($fullMs['SINGLE_EFFECT_LIST'] == 'rotateoutdownright') {
            $out='
               0% {
              '.$transform_origin.': right bottom;
              opacity: 1;
              }
              100% {
              '.$transform_origin.': right bottom;
              '.$tr.': rotate3d(0, 0, 1, -45deg);
              opacity: 0;
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'rotateoutdownleft') {
            $out='
               0% {
              '.$transform_origin.': left bottom;
              opacity: 1;
              }
              100% {
              '.$transform_origin.': left bottom;
              '.$tr.': rotate3d(0, 0, 1, 45deg);
              opacity: 0;
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'rotateout') {
            $out='
               0% {
              '.$transform_origin.': center;
              opacity: 1;
              }
              100% {
              '.$transform_origin.': center;
              '.$tr.': rotate3d(0, 0, 1, 200deg);
              opacity: 0;
              }
            ';
        }
        if($fullMs['SINGLE_EFFECT_LIST'] == 'bounceoutup') {
            $out='
              20% {
              '.$tr.': translate3d(0, -10px, 0);
              }
              40%, 45% {
              opacity: 1;
              '.$tr.': translate3d(0, 20px, 0);
              }
              100% {
              opacity: 0;
              '.$tr.': translate3d(0, -2000px, 0);
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'bounceoutright') {
            $out='
              20% {
              opacity: 1;
              '.$tr.': translate3d(-20px, 0, 0);
              }
              100% {
              opacity: 0;
              '.$tr.': translate3d(2000px, 0, 0);
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'bounceoutleft') {
            $out='
              20% {
              opacity: 1;
              '.$tr.': translate3d(20px, 0, 0);
              }
              100% {
              opacity: 0;
              '.$tr.': translate3d(-2000px, 0, 0);
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'bounceoutdown') {
            $out='
              20% {
              '.$tr.': translate3d(0, 10px, 0);
              }
              40%, 45% {
              opacity: 1;
              '.$tr.': translate3d(0, -20px, 0);
              }
              100% {
              opacity: 0;
              '.$tr.': translate3d(0, 2000px, 0);
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'bounceout') {
            $out='
              20% {
              '.$tr.': scale3d(0.9, 0.9, 0.9);
              }
              50%, 55% {
              opacity: 1;
              '.$tr.': scale3d(1.1, 1.1, 1.1);
              }
              100% {
              opacity: 0;
              '.$tr.': scale3d(0.3, 0.3, 0.3);
              }
            ';
        }
        if($fullMs['SINGLE_EFFECT_LIST'] == 'zoomoutup') {
            $out='
              40% {
                  opacity: 1;
                  '.$tr.': scale3d(0.475, 0.475, 0.475) translate3d(0, 60px, 0);
                  '.$timing.': cubic-bezier(0.550, 0.055, 0.675, 0.190);
                  }
                  100% {
                  opacity: 0;
                  '.$tr.': scale3d(0.1, 0.1, 0.1) translate3d(0, -2000px, 0);
                  '.$transform_origin.': center bottom;
                  '.$timing.': cubic-bezier(0.175, 0.885, 0.320, 1);
                  }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'zoomoutright') {
            $out='
              40% {
              opacity: 1;
              '.$tr.': scale3d(0.475, 0.475, 0.475) translate3d(-42px, 0, 0);
              }
              100% {
              opacity: 0;
              '.$tr.': scale(0.1) translate3d(2000px, 0, 0);
              '.$transform_origin.': right center;
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'zoomoutleft') {
            $out='
              40% {
              opacity: 1;
              '.$tr.': scale3d(0.475, 0.475, 0.475) translate3d(42px, 0, 0);
              }
              100% {
              opacity: 0;
              '.$tr.': scale(.1) translate3d(-2000px, 0, 0);
              '.$transform_origin.': left center;
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'zoomoutdown') {
            $out='
              40% {
              opacity: 1;
              '.$tr.': scale3d(0.475, 0.475, 0.475) translate3d(0, -60px, 0);
              '.$timing.': cubic-bezier(0.550, 0.055, 0.675, 0.190);
              }
              100% {
              opacity: 0;
              '.$tr.': scale3d(.1, .1, .1) translate3d(0, 2000px, 0);
              '.$transform_origin.': center bottom;
              '.$timing.': cubic-bezier(0.175, 0.885, 0.320, 1);
              }
            ';
        }
        if($fullMs['SINGLE_EFFECT_LIST'] == 'fadeoutupbig') {
            $out='
              0% {
              opacity: 1;
              }
              100% {
              opacity: 0;
              '.$tr.': translate3d(0, -2000px, 0);
              }
            ';
        }
        if($fullMs['SINGLE_EFFECT_LIST'] == 'fadeoutup') {
            $out='
             0% {
              opacity: 1;
              }
              100% {
              opacity: 0;
              '.$tr.': translate3d(0, -100%, 0);
              }
            ';
        }
        if($fullMs['SINGLE_EFFECT_LIST'] == 'fadeoutrightbig') {
            $out='
             0% {
              opacity: 1;
              }
              100% {
              opacity: 0;
              '.$tr.': translate3d(2000px, 0, 0);
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'fadeoutright') {
            $out='
             0% {
              opacity: 1;
              }
              100% {
              opacity: 0;
              '.$tr.': translate3d(100%, 0, 0);
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'fadeoutleftbig') {
            $out='
            0% {
              opacity: 1;
              }
              100% {
              opacity: 0;
              '.$tr.': translate3d(-2000px, 0, 0);
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'fadeoutleft') {
            $out='
            0% {
              opacity: 1;
              }
              100% {
              opacity: 0;
              '.$tr.': translate3d(-100%, 0, 0);
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'fadeoutdownbig') {
            $out='
            0% {
              opacity: 1;
              }
              100% {
              opacity: 0;
              '.$tr.': translate3d(0, 2000px, 0);
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'fadeoutdown') {
            $out='
            0% {
              opacity: 1;
              }
              100% {
              opacity: 0;
              '.$tr.': translate3d(0, 100%, 0);
              }
            ';
        }
        if($fullMs['SINGLE_EFFECT_LIST'] == 'slideoutup') {
            $out='
            0% {
              '.$tr.': translateY(0);
              }
              100% {
              visibility: hidden;
              '.$tr.': translateY(-100%);
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'slideoutright') {
            $out='
            0% {
              '.$tr.': translateX(0);
              }
              100% {
              visibility: hidden;
              '.$tr.': translateX(100%);
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'slideoutleft') {
            $out='
            0% {
              '.$tr.': translateX(0);
              }
              100% {
              visibility: hidden;
              '.$tr.': translateX(-100%);
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'slideoutdown') {
            $out='
            0% {
              '.$tr.': translateY(0);
              }
              100% {
              visibility: hidden;
              '.$tr.': translateY(100%);
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'lightspeedout') {
            $out='
                0% {
              opacity: 1;
              }
              100% {
              '.$tr.': translate3d(100%, 0, 0) skewX(30deg);
              opacity: 0;
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'flipouty') {
            $out='
              0% {
              '.$tr.': perspective(400px);
              }
              30% {
              '.$tr.': perspective(400px) rotate3d(0, 1, 0, -15deg);
              opacity: 1;
              }
              100% {
              '.$tr.': perspective(400px) rotate3d(0, 1, 0, 90deg);
              opacity: 0;
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'flipoutx') {
            $out='
              0% {
              '.$tr.': perspective(400px);
              }
              30% {
              '.$tr.': perspective(400px) rotate3d(1, 0, 0, -20deg);
              opacity: 1;
              }
              100% {
              '.$tr.': perspective(400px) rotate3d(1, 0, 0, 90deg);
              opacity: 0;
              }
            ';
        }
        /**/
        if($fullMs['SINGLE_EFFECT_LIST'] == 'swirlinbcktop') {
            $out='
              0% {
                opacity: 0;
                '.$tr.': rotate(-540deg) scale(2);
                '.$transform_origin.': 50% 0;
              }
            
              100% {
                opacity: 1;
                '.$tr.': rotate(0) scale(1);
                '.$transform_origin.': 50% 0;
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'swirlinbckright') {
            $out='
              0% {
                opacity: 0;
                '.$tr.': rotate(-540deg) scale(2);
                '.$transform_origin.': 100% 50%;
              }
            
              100% {
                opacity: 1;
                '.$tr.': rotate(0) scale(1);
                '.$transform_origin.': 100% 50%;
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'swirlinbckleft') {
            $out='
              0% {
                opacity: 0;
                '.$tr.': rotate(-540deg) scale(2);
                '.$transform_origin.': 0 50%;
              }
            
              100% {
                opacity: 1;
                '.$tr.': rotate(0) scale(1);
                '.$transform_origin.': 0 50%;
              }
            ';
        }
        if($fullMs['SINGLE_EFFECT_LIST'] == 'swirlinbckcenter') {
            $out='
                0% {
                opacity: 0;
                '.$tr.': rotate(-540deg) scale(2);
              }
            
              100% {
                opacity: 1;
                '.$tr.': rotate(0) scale(1);
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'swirlinbckbottom') {
            $out='
                0% {
                opacity: 0;
                '.$tr.': rotate(-540deg) scale(2);
                '.$transform_origin.': 50% 100%;
              }
            
              100% {
                opacity: 1;
                '.$tr.': rotate(0) scale(1);
                '.$transform_origin.': 50% 100%;
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'swirlinfwdtop') {
            $out='
                0% {
                opacity: 0;
                '.$tr.': rotate(-540deg) scale(0);
                '.$transform_origin.': 50% 0;
              }
            
              100% {
                opacity: 1;
                '.$tr.': rotate(0) scale(1);
                '.$transform_origin.': 50% 0;
              }
            ';
        }
        if($fullMs['SINGLE_EFFECT_LIST'] == 'swirlinfwdright') {
            $out='
                0% {
                opacity: 0;
                '.$tr.': rotate(-540deg) scale(0);
                '.$transform_origin.': 100% 50%;
              }
            
              100% {
                opacity: 1;
                '.$tr.': rotate(0) scale(1);
                '.$transform_origin.': 100% 50%;
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'swirlinfwdleft') {
            $out='
                0% {
                opacity: 0;
                '.$tr.': rotate(-540deg) scale(0);
                '.$transform_origin.': 0 50%;
              }
            
              100% {
                opacity: 1;
                '.$tr.': rotate(0) scale(1);
                '.$transform_origin.': 0 50%;
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'swirlinfwdcenter') {
            $out='
                0% {
                opacity: 0;
                '.$tr.': rotate(-540deg) scale(0);
              }
            
              100% {
                opacity: 1;
                '.$tr.': rotate(0) scale(1);
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'swirlinfwd') {
            $out='
               0% {
                opacity: 0;
                '.$tr.': rotate(-540deg) scale(0);
                '.$transform_origin.': 50% 100%;
              }
            
              100% {
                opacity: 1;
                '.$tr.': rotate(0) scale(1);
                '.$transform_origin.': 50% 100%;
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'rotateinupright') {
            $out='
               0% {
              '.$transform_origin.': right bottom;
              '.$tr.': rotate3d(0, 0, 1, -90deg);
              opacity: 0;
              }
              100% {
              '.$transform_origin.': right bottom;
              '.$tr.': none;
              opacity: 1;
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'rotateinupleft') {
            $out='
              0% {
              '.$transform_origin.': left bottom;
              '.$tr.': rotate3d(0, 0, 1, 45deg);
              opacity: 0;
              }
              100% {
              '.$transform_origin.': left bottom;
              '.$tr.': none;
              opacity: 1;
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'rotateindownright') {
            $out='
              0% {
              '.$transform_origin.': right bottom;
              '.$tr.': rotate3d(0, 0, 1, 45deg);
              opacity: 0;
              }
              100% {
              '.$transform_origin.': right bottom;
              '.$tr.': none;
              opacity: 1;
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'rotateindownleft') {
            $out='
              0% {
              '.$transform_origin.': left bottom;
              '.$tr.': rotate3d(0, 0, 1, -45deg);
              opacity: 0;
              }
              100% {
              '.$transform_origin.': left bottom;
              '.$tr.': none;
              opacity: 1;
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'rotatein') {
            $out='
            0% {
              '.$transform_origin.': center;
              '.$tr.': rotate3d(0, 0, 1, -200deg);
              opacity: 0;
              }
              100% {
              '.$transform_origin.': center;
              '.$tr.': none;
              opacity: 1;
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'bounceinup') {
            $out='
            0%, 60%, 75%, 90%, 100% {
              '.$transition_timing.': cubic-bezier(0.215, 0.610, 0.355, 1.000);
              }
              0% {
              opacity: 0;
              '.$tr.': translate3d(0, 3000px, 0);
              }
              60% {
              opacity: 1;
              '.$tr.': translate3d(0, -20px, 0);
              }
              75% {
              '.$tr.': translate3d(0, 10px, 0);
              }
              90% {
              '.$tr.': translate3d(0, -5px, 0);
              }
              100% {
              '.$tr.': translate3d(0, 0, 0);
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'bounceinright') {
            $out='
            0%, 60%, 75%, 90%, 100% {
              '.$transition_timing.': cubic-bezier(0.215, 0.610, 0.355, 1.000);
              }
              0% {
              opacity: 0;
              '.$tr.': translate3d(3000px, 0, 0);
              }
              60% {
              opacity: 1;
              '.$tr.': translate3d(-25px, 0, 0);
              }
              75% {
              '.$tr.': translate3d(10px, 0, 0);
              }
              90% {
              '.$tr.': translate3d(-5px, 0, 0);
              }
              100% {
              '.$tr.': none;
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'bounceinleft') {
            $out='
            0%, 60%, 75%, 90%, 100% {
              '.$transition_timing.': cubic-bezier(0.215, 0.610, 0.355, 1.000);
              }
              0% {
              opacity: 0;
              '.$tr.': translate3d(-3000px, 0, 0);
              }
              60% {
              opacity: 1;
              '.$tr.': translate3d(25px, 0, 0);
              }
              75% {
              '.$tr.': translate3d(-10px, 0, 0);
              }
              90% {
              '.$tr.': translate3d(5px, 0, 0);
              }
              100% {
              '.$tr.': none;
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'bounceindown') {
            $out='
            0%, 60%, 75%, 90%, 100% {
              '.$transition_timing.': cubic-bezier(0.215, 0.610, 0.355, 1.000);
              }
              
              0% {
              opacity: 0;
              '.$tr.': translate3d(0, -3000px, 0);
              }
              
              60% {
              opacity: 1;
              '.$tr.': translate3d(0, 25px, 0);
              }
              
              75% {
              '.$tr.': translate3d(0, -10px, 0);
              }
              
              90% {
              '.$tr.': translate3d(0, 5px, 0);
              }
              
              100% {
              '.$tr.': none;
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'bouncein') {
            $out='
            0%, 20%, 40%, 60%, 80%, 100% {
              '.$transition_timing.': cubic-bezier(0.215, 0.610, 0.355, 1.000);
              }
              0% {
              opacity: 0;
              '.$tr.': scale3d(.3, .3, .3);
              }
              20% {
              '.$tr.': scale3d(1.1, 1.1, 1.1);
              }
              40% {
              '.$tr.': scale3d(.9, .9, .9);
              }
              60% {
              opacity: 1;
              '.$tr.': scale3d(1.03, 1.03, 1.03);
              }
              80% {
              '.$tr.': scale3d(.97, .97, .97);
              }
              100% {
              opacity: 1;
              '.$tr.': scale3d(1, 1, 1);
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'zoominup') {
            $out='
            0% {
              opacity: 0;
              '.$tr.': scale3d(0.1, 0.1, 0.1) translate3d(0, 1000px, 0);
              '.$timing.': cubic-bezier(0.550, 0.055, 0.675, 0.190);
              }
              60% {
              opacity: 1;
              '.$tr.': scale3d(0.475, 0.475, 0.475) translate3d(0, -60px, 0);
              '.$timing.': cubic-bezier(0.175, 0.885, 0.320, 1);
              }
              100% {
              opacity: 1;
              '.$tr.': scale3d(1, 1, 1) translate3d(0, 0px, 0);
              '.$timing.': cubic-bezier(0.175, 0.885, 0.320, 1);
              }
            ';
            /* Есть добавка для цепочкт анимаций */
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'zoominright') {
            $out='
            0% {
              opacity: 0;
              '.$tr.': scale3d(0.1, 0.1, 0.1) translate3d(1000px, 0, 0);
              '.$timing.': cubic-bezier(0.550, 0.055, 0.675, 0.190);
              }
              60% {
              opacity: 1;
              '.$tr.': scale3d(0.475, 0.475, 0.475) translate3d(-10px, 0, 0);
              '.$timing.': cubic-bezier(0.175, 0.885, 0.320, 1);
              }
              100% {
              opacity: 1;
              '.$tr.': scale3d(1, 1, 1) translate3d(0px, 0, 0);
              '.$timing.': cubic-bezier(0.175, 0.885, 0.320, 1);
              }
              
            ';
            /* Есть добавка для цепочкт анимаций */
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'zoominleft') {
            $out='
            0% {
              opacity: 0;
              '.$tr.': scale3d(0.1, 0.1, 0.1) translate3d(-1000px, 0, 0);
              '.$timing.': cubic-bezier(0.550, 0.055, 0.675, 0.190);
              }
              60% {
              opacity: 1;
              '.$tr.': scale3d(0.475, 0.475, 0.475) translate3d(10px, 0, 0);
              '.$timing.': cubic-bezier(0.175, 0.885, 0.320, 1);
              }
              100% {
              opacity: 1;
              '.$tr.': scale3d(1, 1, 1) translate3d(0px, 0, 0);
              '.$timing.': cubic-bezier(0.175, 0.885, 0.320, 1);
              }
            ';
            /* Есть добавка для цепочкт анимаций */
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'zoomindown') {
            $out='
            0% {
              opacity: 0;
              '.$tr.': scale3d(0.1, 0.1, 0.1) translate3d(0, -1000px, 0);
              '.$timing.': cubic-bezier(0.550, 0.055, 0.675, 0.190);
              }
              60% {
              opacity: 1;
              '.$tr.': scale3d(0.475, 0.475, 0.475) translate3d(0, 60px, 0);
              '.$timing.': cubic-bezier(0.175, 0.885, 0.320, 1);
              }
              100% {
              opacity: 1;
              '.$tr.': scale3d(1, 1, 1) translate3d(0, 0px, 0);
              '.$timing.': cubic-bezier(0.175, 0.885, 0.320, 1);
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'zoomin') {
            $out='
            0% {
              opacity: 0;
              '.$tr.': scale3d(0.3, 0.3, 0.3);
              }
              50% {
              opacity: 1;
              }
              100% {
              opacity: 1;
              }
            ';
            /* Добавка для цепочкт анимаций */
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'fadeinupbig') {
            $out='
            0% {
              opacity: 0;
              '.$tr.': translate3d(0, 2000px, 0);
              }
              100% {
              opacity: 1;
              '.$tr.': none;
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'fadeinup') {
            $out='
            0% {
              opacity: 0;
              '.$tr.': translate3d(0, 100%, 0);
              }
              100% {
              opacity: 1;
              '.$tr.': none;
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'fadeinrightbig') {
            $out='
            0% {
              opacity: 0;
              '.$tr.': translate3d(2000px, 0, 0);
              }
              100% {
              opacity: 1;
              '.$tr.': none;
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'fadeinright') {
            $out='
            0% {
              opacity: 0;
              '.$tr.': translate3d(100%, 0, 0);
              }
              100% {
              opacity: 1;
              '.$tr.': none;
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'fadeinleftbig') {
            $out='
            0% {
              opacity: 0;
              '.$tr.': translate3d(-2000px, 0, 0);
              }
              100% {
              opacity: 1;
              '.$tr.': none;
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'fadeinleft') {
            $out='
            0% {
              opacity: 0;
              '.$tr.': translate3d(-100%, 0, 0);
              }
              100% {
              opacity: 1;
              '.$tr.': none;
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'fadeindownbig') {
            $out='
            0% {
              opacity: 0;
              '.$tr.': translate3d(0, -2000px, 0);
              }
              100% {
              opacity: 1;
              '.$tr.': none;
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'fadeindown') {
            $out='
            0% {
              opacity: 0;
              '.$tr.': translate3d(0, -100%, 0);
              }
              100% {
              opacity: 1;
              '.$tr.': none;
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'slideinup') {
            $out='
            0% {
              '.$tr.': translateY(100%);
              visibility: visible;
              }
              100% {
              '.$tr.': translateY(0);
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'slideinright') {
            $out='
            0% {
              '.$tr.': translateX(100%);
                visibility: visible;
              }
              100% {
                '.$tr.': translateX(0);
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'slideinleft') {
            $out='
            0% {
              '.$tr.': translateX(-100%);
              visibility: visible;
              }
              100% {
              '.$tr.': translateX(0);
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'slideindown') {
            $out='
            0% {
              '.$tr.': translateY(-100%);
              visibility: visible;
              }
              100% {
              '.$tr.': translateY(0);
              }
            ';
        }
        if($fullMs['SINGLE_EFFECT_LIST'] == 'flipiny') {
            $out='
            0% {
              '.$tr.': perspective(400px) rotate3d(0, 1, 0, 90deg);
              '.$timing.': ease-in;
              opacity: 0;
              }
              40% {
              '.$tr.': perspective(400px) rotate3d(0, 1, 0, -20deg);
              '.$timing.': ease-in;
              }
              60% {
              '.$tr.': perspective(400px) rotate3d(0, 1, 0, 10deg);
              opacity: 1;
              }
              80% {
              '.$tr.': perspective(400px) rotate3d(0, 1, 0, -5deg);
              }
              100% {
              '.$tr.': perspective(400px);
              }
            ';
        }
        if($fullMs['SINGLE_EFFECT_LIST'] == 'flipinx') {
            $out='
              0% {
              '.$tr.': perspective(400px) rotate3d(1, 0, 0, 90deg);
              '.$timing.': ease-in;
              opacity: 0;
              }
              40% {
              '.$tr.': perspective(400px) rotate3d(1, 0, 0, -20deg);
              '.$timing.': ease-in;
              }
              60% {
              '.$tr.': perspective(400px) rotate3d(1, 0, 0, 10deg);
              opacity: 1;
              }
              80% {
              '.$tr.': perspective(400px) rotate3d(1, 0, 0, -5deg);
              }
              100% {
              '.$tr.': perspective(400px);
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'wobble') {
            $out='
              0% {
              '.$tr.': none;
              }
              15% {
              '.$tr.': translate3d(-25%, 0, 0) rotate3d(0, 0, 1, -5deg);
              }
              30% {
              '.$tr.': translate3d(20%, 0, 0) rotate3d(0, 0, 1, 3deg);
              }
              45% {
              '.$tr.': translate3d(-15%, 0, 0) rotate3d(0, 0, 1, -3deg);
              }
              60% {
              '.$tr.': translate3d(10%, 0, 0) rotate3d(0, 0, 1, 2deg);
              }
              75% {
              '.$tr.': translate3d(-5%, 0, 0) rotate3d(0, 0, 1, -1deg);
              }
              100% {
              '.$tr.': none;
              }
            ';
        }
        if($fullMs['SINGLE_EFFECT_LIST'] == 'tada') {
            $out='
              0% {
              '.$tr.': scale3d(1, 1, 1);
              }
              10%, 20% {
              '.$tr.': scale3d(.9, .9, .9) rotate3d(0, 0, 1, -3deg);
              }
              30%, 50%, 70%, 90% {
              '.$tr.': scale3d(1.1, 1.1, 1.1) rotate3d(0, 0, 1, 3deg);
              }
              40%, 60%, 80% {
              '.$tr.': scale3d(1.1, 1.1, 1.1) rotate3d(0, 0, 1, -3deg);
              }
              100% {
              '.$tr.': scale3d(1, 1, 1);
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'swing') {
            $out='
              20% {
              '.$tr.': rotate3d(0, 0, 1, 15deg);
              }
              40% {
              '.$tr.': rotate3d(0, 0, 1, -10deg);
              }
              60% {
              '.$tr.': rotate3d(0, 0, 1, 5deg);
              }
              80% {
              '.$tr.': rotate3d(0, 0, 1, -5deg);
              }
              100% {
              '.$tr.': rotate3d(0, 0, 1, 0deg);
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'shake') {
            $out='
             0%, 100% {
               '.$tr.': translate3d(0, 0, 0);
              }
              10%, 30%, 50%, 70%, 90% {
               '.$tr.': translate3d(-10px, 0, 0);
              }
              20%, 40%, 60%, 80% {
               '.$tr.': translate3d(10px, 0, 0);
              }
            ';
        }

        if($fullMs['SINGLE_EFFECT_LIST'] == 'pulse') {
            $out='
              0% {
              '.$tr.': scale3d(1, 1, 1);
              }
              50% {
              '.$tr.': scale3d(1.05, 1.05, 1.05);
              }
              100% {
              '.$tr.': scale3d(1, 1, 1);
              }
            ';
        }
        if($fullMs['SINGLE_EFFECT_LIST'] == 'flash') {
            $out='
            0%, 50%, 100% {
                opacity: 1;
            }
            25%, 75% {
                opacity: 0;
            }
            ';
        }
        if($fullMs['SINGLE_EFFECT_LIST'] == 'bounce') {
            $out='0%, 20%, 53%, 80%, 100% {
            '.$transition_timing.': cubic-bezier(0.215, 0.610, 0.355, 1.000);
            '.$tr.': translate3d(0,0,0);
            }
            40%, 43% {
            '.$transition_timing.': cubic-bezier(0.755, 0.050, 0.855, 0.060);
            '.$tr.': translate3d(0, -30px, 0);
            }
            70% {
            '.$transition_timing.': cubic-bezier(0.755, 0.050, 0.855, 0.060);
            '.$tr.': translate3d(0, -15px, 0);
            }
            90% {
            '.$tr.': translate3d(0,-4px,0);
            }
            
            ';
        }
        if($fullMs['SINGLE_EFFECT_LIST'] == 'bounceballbottom') {
            /* Прыгающий мячик */
            $out='
              0% {
              '.$tr.': scale3d(1, 1, 1) translateY(0%);
              }
              30% {
              '.$tr.': scale3d(1.25, 0.75, 1) translateY(12.5%);
              }
              40% {
              '.$tr.': scale3d(0.75, 1.25, 1) translateY(-20.5%);
              }
              50% {
              '.$tr.': scale3d(1.15, 0.85, 1) translateY(7.5%);
              }
              65% {
              '.$tr.': scale3d(.95, 1.05, 1) translateY(-4.5%);
              }
              75% {
              '.$tr.': scale3d(1.05, .95, 1) translateY(2.5%);
              }
              100% {
              '.$tr.': scale3d(1, 1, 1) translateY(0%);
              }
            ';
            $out = self::getBallBottom($tr);
        }
        if($fullMs['SINGLE_EFFECT_LIST'] == 'speedin') {
            $out='
              0% {
              '.$tr.': translate3d(100%, 0, 0) skewX(-30deg);
              opacity: 0;
              }
              60% {
              '.$tr.': skewX(20deg);
              opacity: 1;
              }
              80% {
              '.$tr.': skewX(-5deg);
              opacity: 1;
              }
              100% {
              '.$tr.': none;
              opacity: 1;
              }
            ';
        }
        if($fullMs['SINGLE_EFFECT_LIST'] == 'rubber') {
            $out='
              0% {
              '.$tr.': scale3d(1, 1, 1);
              }
              30% {
              '.$tr.': scale3d(1.25, 0.75, 1);
              }
              40% {
              '.$tr.': scale3d(0.75, 1.25, 1);
              }
              50% {
              '.$tr.': scale3d(1.15, 0.85, 1);
              }
              65% {
              '.$tr.': scale3d(.95, 1.05, 1);
              }
              75% {
              '.$tr.': scale3d(1.05, .95, 1);
              }
              100% {
              '.$tr.': scale3d(1, 1, 1);
              }
            ';
        }
        if($fullMs['SINGLE_EFFECT_LIST'] == 'flip1') {
            $px = 500;
            $out='
              0% {
              '.$tr.': perspective('.$px.'px) rotate3d(0, 1, 0, -360deg);
              '.$timing.': ease-out;
              }
              40% {
              '.$tr.': perspective('.$px.'px) translate3d(0, 0, 150px) rotate3d(0, 1, 0, -190deg);
              '.$timing.': ease-out;
              }
              50% {
              '.$tr.': perspective('.$px.'px) translate3d(0, 0, 150px) rotate3d(0, 1, 0, -170deg);
              '.$timing.': ease-in;
              }
              80% {
              '.$tr.': perspective('.$px.'px) scale3d(.95, .95, .95);
              '.$timing.': ease-in;
              }
              100% {
              '.$tr.': perspective('.$px.'px);
              '.$timing.': ease-in;
              }
            ';
        }

        return $out;
    }
    static function getBallBottom($tr) {
        /*
         * Мячик прыгает на полу
         */
        $out="";
        $jumpCount = 2;
        $iz = 0;
        $iz2 = 0;
        $procDiff = 100/(7*$jumpCount);
        $procDiffY = 40;
        $proc = 0;
        $delenie = 0;
        $delenie2 = 0;
        $diffSc = 0.4;
        $plus = 1;
        for($iz = 0;$iz<$jumpCount; $iz++) {
            $iz2 = 0;
            $delenie++;
            for($iz2 = 0;$iz2<7; $iz2++) {
                $delenie2++;
                if($iz === 0 && $iz2 === 0) {
                }else {
                    $proc = $proc + round($procDiff,0);
                }
                $plus = $plus*-1;
                if ($delenie2 > 1) {
                        $s1 = 1 + $diffSc / ($delenie2 - 1)*$plus;
                        $proc2= round($procDiffY/($delenie2 - 1)*$plus, 2);
                } else {
                        $s1 = 1;
                        $proc2= 0;
                }
                if ($delenie2 > 1) {
                    $s2 = 1 + $diffSc / ($delenie2 - 1)*$plus*-1;
                } else {
                    $s2 = 1;
                }
                $s3=1;
                $out=$out.'
              '.$proc.'% {
              '.$tr.': scale3d('.round($s1,4).', '.round($s2,4).', '.round($s3,2).') translateY('.$proc2.'%);
              }
              ';
            }

        }
        return $out;
    }
    static function getMsTremolo() {
        $ms_deg = Array(
            Array(
                "perc"=>0,
                "deg"=>0,
            ),
            Array(
                "perc"=>10,
                "deg"=>-30,
            ),
            Array(
                "perc"=>20,
                "deg"=>15,
            ),
            Array(
                "perc"=>30,
                "deg"=>-10,
            ),
            Array(
                "perc"=>40,
                "deg"=>7.5,
            ),
            Array(
                "perc"=>50,
                "deg"=>-6,
            ),
            Array(
                "perc"=>60,
                "deg"=>5,
            ),
            Array(
                "perc"=>70,
                "deg"=>-4.28,
            ),
            Array(
                "perc"=>80,
                "deg"=>3.75,
            ),
            Array(
                "perc"=>90,
                "deg"=>-3.33,
            ),
            Array(
                "perc"=>100,
                "deg"=>0,
            ),
        );
        return $ms_deg;
    }
    static function getComplexEffectTranform($br,$eff){
        $msTremolo = self::getMsTremolo();
        $col = count($msTremolo);
        $out_itog="";
        $iz=0;
        foreach ($msTremolo as $val) {
            $fl_x=0;
            $fl_y=0;
            $fl_z=0;
            $out='
            '.$val["perc"].'% {
            '.$br.': ';
            if (strpos($eff, "rotate_repspective_x_1") !== false  && $fl_x === 0) {
                $degAll = $iz*360/($col-1) * 1;
                $out=$out.$br.' rotateX('.$degAll.'deg) ';
                $fl_x=1;
            }
            if (strpos($eff, "rotate_repspective_x_2") !== false  && $fl_x === 0) {
                $degAll = $iz*360/($col-1) * -1;
                $out=$out.' rotateX('.$degAll.'deg) ';
                $fl_x=1;
            }

            if (strpos($eff, "rotate_repspective_y_1") !== false  && $fl_y === 0) {
                $degAll = $iz*360/($col-1) * 1;
                $out=$out.' rotateY('.$degAll.'deg) ';
                $fl_y=1;
            }
            if (strpos($eff, "rotate_repspective_y_2") !== false  && $fl_y === 0) {
                $degAll = $iz*360/($col-1) * -1;
                $out=$out.' rotateY('.$degAll.'deg) ';
                $fl_y=1;
            }

            if (strpos($eff, "rotate_x") !== false && $fl_x === 0) {
                $degAll = $iz*360/($col-1);
                $out=$out.' rotateX('.$degAll.'deg) ';
                $fl_x=1;
            }
            if (strpos($eff, "rotate_y") !== false  && $fl_y === 0) {
                $degAll = $iz*360/($col-1);
                $out=$out.' rotateY('.$degAll.'deg) ';
                $fl_y=1;
            }
            if (strpos($eff, "circle_left") !== false  && $fl_z === 0) {
                if (strpos($eff, "telefon") !== false) {
                    $degAll = $iz*360/($col-1) * -1 + $val['deg'];
                }
                $out=$out.' rotateZ('.$degAll.'deg) ';
                $fl_z=1;
            }
            if (strpos($eff, "circle_right") !== false  && $fl_z === 0) {
                if (strpos($eff, "telefon") !== false) {
                    $degAll = $iz*360/($col-1) * 1 + $val['deg'];
                }
                $out=$out.' rotateZ('.$degAll.'deg) ';
                $fl_z=1;
            }

            if (strpos($eff, "from_small_to_big") !== false) {
                $z05 = $col/2;
                if($iz<=$z05) {
                    $degAll = $iz/$z05;
                }else {
                    $degAll = 1-($iz-$z05)/$z05;
                }
                $out=$out.' scale('.$degAll.') ';
            }
            if (strpos($eff, "from_big_to_small") !== false) {
                $z05 = $col/2;
                if($iz<=$z05) {
                    $degAll = 1-($z05- $iz)/$z05;
                }else {
                    $degAll = 1-($iz - $z05)/$z05;
                }
                $out=$out.': scale('.$degAll.') ';
            }
            if (strpos($eff, "telefon") !== false && $fl_z === 0) {
                $out=$out.' rotateZ('.$val["deg"].'deg) ';
            }


            $out=$out.'
                ;}';
            $out_itog = $out_itog.$out;

            $iz++;
        }
        return $out_itog;
    }
    static function getOneTelefonEffect($br) {
        $msTremolo = self::getMsTremolo();
        $out="";
        foreach ($msTremolo as $val) {
            $out=$out.$val["perc"].'% {
            '.$br.': rotateZ('.$val["deg"].'deg);
            }
            ';
        }
        return $out;
    }
    static function hexToRgb($hex, $alpha = false) {
        $hex      = str_replace('#', '', $hex);
        $length   = strlen($hex);
        $rgb['r'] = hexdec($length == 6 ? substr($hex, 0, 2) : ($length == 3 ? str_repeat(substr($hex, 0, 1), 2) : 0));
        $rgb['g'] = hexdec($length == 6 ? substr($hex, 2, 2) : ($length == 3 ? str_repeat(substr($hex, 1, 1), 2) : 0));
        $rgb['b'] = hexdec($length == 6 ? substr($hex, 4, 2) : ($length == 3 ? str_repeat(substr($hex, 2, 1), 2) : 0));
        if ( $alpha ) {
            $rgb['a'] = $alpha;
        }
        return $rgb;
    }

    static function  get_implodeEffect() {
        $out = array(
            "rotate_x"=>Array("rotateX",'(0deg)','(360deg)' ,'(180deg)'),
            "rotate_y"=>Array("rotateY",'(0deg)','(360deg)','(180deg)'),
            "circle_left"=>Array("rotateZ",'(0deg)','(-360deg)','(-180deg)'),
            "circle_right"=>Array("rotateZ",'(0deg)','(360deg)','(180deg)'),
            "rotate_repspective_x_1"=>Array("rotateX",'(0deg)','(360deg)','(180deg)'),
            "rotate_repspective_x_2"=>Array("rotateX",'(0deg)','(-360deg)','(-180deg)'),
            "rotate_repspective_y_1"=>Array("rotateY",'(0deg)','(360deg)','(180deg)'),
            "rotate_repspective_y_2"=>Array("rotateY",'(0deg)','(-360deg)','(-180deg)'),
            "from_small_to_big"=>Array("scale",'(0)','(0)','(1)'),
            "from_big_to_small"=>Array("scale",'(1)','(1)','(0)'),
        );
        return $out;
    }
    static function getSelectBoxSingleEffect($grupp) {
        /**
         * Статический перечень дополнительных ОДНИНОЧНЫХ эффектов анимации для селектбокса Визуального редактора
         */
        $out0 = Array(
            "flip1" => GetMessage("ANIMATEDGRAPHICS_FLIP1"),
            "flipinx" => GetMessage("ANIMATEDGRAPHICS_FLIPINX"),
            "flipiny" => GetMessage("ANIMATEDGRAPHICS_FLIPINY"),
            "flipoutx" => GetMessage("ANIMATEDGRAPHICS_FLIPOUTX"),
            "flipouty" => GetMessage("ANIMATEDGRAPHICS_FLIPOUTY"),


            "rubber" => GetMessage("ANIMATEDGRAPHICS_RUBBER2"),

            "speedin" => GetMessage("ANIMATEDGRAPHICS_SPEEDIN3"),
            "lightspeedout" => GetMessage("ANIMATEDGRAPHICS_LIGHTSPEEDOUT"),

            "slideindown" => GetMessage("ANIMATEDGRAPHICS_SLIDEINDOWN"),
            "slideinleft" => GetMessage("ANIMATEDGRAPHICS_SLIDEINLEFT"),
            "slideinright" => GetMessage("ANIMATEDGRAPHICS_SLIDEINRIGHT"),
            "slideinup" => GetMessage("ANIMATEDGRAPHICS_SLIDEINUP"),
            "slideoutdown" => GetMessage("ANIMATEDGRAPHICS_SLIDEOUTDOWN"),
            "slideoutleft" => GetMessage("ANIMATEDGRAPHICS_SLIDEOUTLEFT"),
            "slideoutright" => GetMessage("ANIMATEDGRAPHICS_SLIDEOUTRIGHT"),
            "slideoutup" => GetMessage("ANIMATEDGRAPHICS_SLIDEOUTUP"),

            "fadeindown" => GetMessage("ANIMATEDGRAPHICS_FADEINDOWN"),
            "fadeindownbig" => GetMessage("ANIMATEDGRAPHICS_FADEINDOWNBIG"),
            "fadeinleft" => GetMessage("ANIMATEDGRAPHICS_FADEINLEFT"),
            "fadeinleftbig" => GetMessage("ANIMATEDGRAPHICS_FADEINLEFTBIG"),
            "fadeinright" => GetMessage("ANIMATEDGRAPHICS_FADEINRIGHT"),
            "fadeinrightbig" => GetMessage("ANIMATEDGRAPHICS_FADEINRIGHTBIG"),
            "fadeinup" => GetMessage("ANIMATEDGRAPHICS_FADEINUP"),
            "fadeinupbig" => GetMessage("ANIMATEDGRAPHICS_FADEINUPBIG"),
            "fadeoutdown" => GetMessage("ANIMATEDGRAPHICS_FADEOUTDOWN"),
            "fadeoutdownbig" => GetMessage("ANIMATEDGRAPHICS_FADEOUTDOWNBIG"),
            "fadeoutleft" => GetMessage("ANIMATEDGRAPHICS_FADEOUTLEFT"),
            "fadeoutleftbig" => GetMessage("ANIMATEDGRAPHICS_FADEOUTLEFTBIG"),
            "fadeoutright" => GetMessage("ANIMATEDGRAPHICS_FADEOUTRIGHT"),
            "fadeoutrightbig" => GetMessage("ANIMATEDGRAPHICS_FADEOUTRIGHTBIG"),
            "fadeoutup" => GetMessage("ANIMATEDGRAPHICS_FADEOUTUP"),
            "fadeoutupbig" => GetMessage("ANIMATEDGRAPHICS_FADEOUTUPBIG"),

            "zoomin" => GetMessage("ANIMATEDGRAPHICS_ZOOMIN"),
            "zoomindown" => GetMessage("ANIMATEDGRAPHICS_ZOOMINDOWN"),
            "zoominleft" => GetMessage("ANIMATEDGRAPHICS_ZOOMINLEFT"),
            "zoominright" => GetMessage("ANIMATEDGRAPHICS_ZOOMINRIGHT"),
            "zoominup" => GetMessage("ANIMATEDGRAPHICS_ZOOMINUP"),
            "zoomoutdown" => GetMessage("ANIMATEDGRAPHICS_ZOOMOUTDOWN"),
            "zoomoutleft" => GetMessage("ANIMATEDGRAPHICS_ZOOMOUTDOWN"),
            "zoomoutright" => GetMessage("ANIMATEDGRAPHICS_ZOOMOUTRIGHT"),
            "zoomoutup" => GetMessage("ANIMATEDGRAPHICS_ZOOMOUTUP"),

            "bounce" => GetMessage("ANIMATEDGRAPHICS_BOUNCE"),
            "bounceballbottom"=>GetMessage("ANIMATEDGRAPHICS_BOUNCEBALLBOTTOM"),
            "bouncein" => GetMessage("ANIMATEDGRAPHICS_BOUNCEIN"),
            "bounceindown" => GetMessage("ANIMATEDGRAPHICS_BOUNCEINDOWN"),
            "bounceinleft" => GetMessage("ANIMATEDGRAPHICS_BOUNCEINLEFT"),
            "bounceinright" => GetMessage("ANIMATEDGRAPHICS_BOUNCEINRIGHT"),
            "bounceinup" => GetMessage("ANIMATEDGRAPHICS_BOUNCEINUP"),

            //"bounceinup2" => GetMessage("ANIMATEDGRAPHICS_BOUNCEINUP2"),

            "bounceout" => GetMessage("ANIMATEDGRAPHICS_BOUNCEOUT"),
            "bounceoutdown" => GetMessage("ANIMATEDGRAPHICS_BOUNCEOUTDOWN"),
            "bounceoutleft" => GetMessage("ANIMATEDGRAPHICS_BOUNCEOUTLEFT"),
            "bounceoutright" => GetMessage("ANIMATEDGRAPHICS_BOUNCEOUTRIGHT"),
            "bounceoutup" => GetMessage("ANIMATEDGRAPHICS_BOUNCEOUTUP"),

            "rotatein" => GetMessage("ANIMATEDGRAPHICS_ROTATEIN"),
            "rotateindownleft" => GetMessage("ANIMATEDGRAPHICS_ROTATEINDOWNLEFT"),
            "rotateindownright" => GetMessage("ANIMATEDGRAPHICS_ROTATEINDOWNRIGHT"),
            "rotateinupleft" => GetMessage("ANIMATEDGRAPHICS_ROTATEINUPLEFT"),
            "rotateinupright" => GetMessage("ANIMATEDGRAPHICS_ROTATEINUPRIGHT"),
            "rotateout" => GetMessage("ANIMATEDGRAPHICS_ROTATEOUT"),
            "rotateoutdownleft" => GetMessage("ANIMATEDGRAPHICS_ROTATEOUTDOWNLEFT"),
            "rotateoutupleft" => GetMessage("ANIMATEDGRAPHICS_ROTATEOUTUPLEFT"),
            "rotateoutdownright" => GetMessage("ANIMATEDGRAPHICS_ROTATEOUTDOWNRIGHT"),
            "rotateoutupright" => GetMessage("ANIMATEDGRAPHICS_ROTATEOUTUPRIGHT"),

            "flash" => GetMessage("ANIMATEDGRAPHICS_FLASH"),
            /*2*/
            /*"flash2" => GetMessage("ANIMATEDGRAPHICS_FLASH2"),
            "flash3" => GetMessage("ANIMATEDGRAPHICS_FLASH3"),*/

            "pulse" => GetMessage("ANIMATEDGRAPHICS_PULSE"),
            "shake" => GetMessage("ANIMATEDGRAPHICS_SHAKE"),
            "swing" => GetMessage("ANIMATEDGRAPHICS_SWING"),
            "tada" => GetMessage("ANIMATEDGRAPHICS_TADA"),
            "wobble" => GetMessage("ANIMATEDGRAPHICS_WOBBLE"),

            "swirlinfwd"=>GetMessage("ANIMATEDGRAPHICS_SWIRLINFWD_BOTTOM"),
            "swirlinfwdcenter"=>GetMessage("ANIMATEDGRAPHICS_SWIRLINFWD_CENTER"),
            "swirlinfwdleft"=>GetMessage("ANIMATEDGRAPHICS_SWIRLINFWD_LEFT"),
            "swirlinfwdright"=>GetMessage("ANIMATEDGRAPHICS_SWIRLINFWD_RIGHT"),
            "swirlinfwdtop"=>GetMessage("ANIMATEDGRAPHICS_SWIRLINFWD_TOP"),

            "swirlinbckbottom"=>GetMessage("ANIMATEDGRAPHICS_SWIRLINBCK_BOTTOM"),
            "swirlinbckcenter"=>GetMessage("ANIMATEDGRAPHICS_SWIRLINBCK_CENTER"),
            "swirlinbckleft"=>GetMessage("ANIMATEDGRAPHICS_SWIRLINBCK_LEFT"),
            "swirlinbckright"=>GetMessage("ANIMATEDGRAPHICS_SWIRLINBCK_RIGHT"),
            "swirlinbcktop"=>GetMessage("ANIMATEDGRAPHICS_SWIRLINBCK_TOP"),

            "swirloutfwd"=>GetMessage("ANIMATEDGRAPHICS_SWIRLOUTFWD_BOTTOM"),
            "swirloutfwdcenter"=>GetMessage("ANIMATEDGRAPHICS_SWIRLOUTFWD_CENTER"),
            "swirloutfwdleft"=>GetMessage("ANIMATEDGRAPHICS_SWIRLOUTFWD_LEFT"),
            "swirloutfwdright"=>GetMessage("ANIMATEDGRAPHICS_SWIRLOUTFWD_RIGHT"),
            "swirloutfwdtop"=>GetMessage("ANIMATEDGRAPHICS_SWIRLOUTFWD_TOP"),

            "swirloutbckbottom"=>GetMessage("ANIMATEDGRAPHICS_SWIRLOUTBCK_BOTTOM"),
            "swirloutbckcenter"=>GetMessage("ANIMATEDGRAPHICS_SWIRLOUTBCK_CENTER"),
            "swirloutbckleft"=>GetMessage("ANIMATEDGRAPHICS_SWIRLOUTBCK_LEFT"),
            "swirloutbckright"=>GetMessage("ANIMATEDGRAPHICS_SWIRLOUTBCK_RIGHT"),
            "swirloutbcktop"=>GetMessage("ANIMATEDGRAPHICS_SWIRLOUTBCK_TOP"),

        );
        if($grupp == 'allgrupp' || $grupp == '') {
            $out = $out0;
        }else{
            $out = array();
            $ms_grupp = self::getGruppEffect();
            foreach ($out0 as $key => $val) {
                foreach ($ms_grupp as $key2 => $val2) {
                    if ($grupp == $key2) {
                        if (in_array($key, $val2["CODE_EFF"])) {
                            $out[$key] = $val;
                        }
                    }
                }
            }
        }
        return $out;

    }
    static function getGruppEffect() {
        /**
         * Отдаёт  статический массив соотвествия эффекта группе Эффектов. Входных параметров нет
         */
        $out = Array(
            "attention"=>Array(
                "NAME"=>GetMessage("ANIMATEDGRAPHICS_GRUPP_ATTENTION"),
                "NAME2"=>GetMessage("ANIMATEDGRAPHICS_GRUPP_ATTENTION2"),
                "CODE_EFF"=> Array(
                   "flip1",
                   "rubber",
                    "bounce",
                    "bounceballbottom",
                    "flash",
                    "pulse",
                    "shake",
                    "swing",
                    "tada",
                    "wobble",
                ),
            ),
            "entrance"=>Array(
                "NAME"=>GetMessage("ANIMATEDGRAPHICS_GRUPP_ENTRANCE"),
                "NAME2"=>GetMessage("ANIMATEDGRAPHICS_GRUPP_ENTRANCE2"),
                "CODE_EFF"=> Array(
                    "flipinx",
                    "flipiny",
                    "speedin",
                    "slideindown",
                    "slideinleft",
                    "slideinright",
                    "slideinup",
                    "fadeindown",
                    "fadeindownbig",
                    "fadeinleft",
                    "fadeinleftbig",
                    "fadeinright",
                    "fadeinrightbig",
                    "fadeinup",
                    "fadeinupbig",
                    "zoomin",
                    "zoomindown",
                    "zoominleft",
                    "zoominright",
                    "zoominup",
                    "bouncein",
                    "bounceindown",
                    "bounceinleft",
                    "bounceinright",
                    "bounceinup",
                    "rotatein",
                    "rotateindownleft",
                    "rotateindownright",
                    "rotateinupleft",
                    "rotateinupright",

                    "swirlinfwd",
                    "swirlinfwdcenter",
                    "swirlinfwdleft",
                    "swirlinfwdright",
                    "swirlinfwdtop",
                    "swirlinbckbottom",
                    "swirlinbckcenter",
                    "swirlinbckleft",
                    "swirlinbckright",
                    "swirlinbcktop",

                ),
            ),
            "exit"=>Array(
                "NAME"=>GetMessage("ANIMATEDGRAPHICS_GRUPP_EXIT"),
                "NAME2"=>GetMessage("ANIMATEDGRAPHICS_GRUPP_EXIT2"),
                "CODE_EFF"=> Array(
                    "flipoutx",
                    "flipouty",
                    "lightspeedout",
                    "slideoutdown",
                    "slideoutleft",
                    "slideoutright",
                    "slideoutup",
                    "fadeoutdown",
                    "fadeoutdownbig",
                    "fadeoutleft",
                    "fadeoutleftbig",
                    "fadeoutright",
                    "fadeoutrightbig",
                    "fadeoutup",
                    "fadeoutupbig",
                    "zoomoutdown",
                    "zoomoutleft",
                    "zoomoutright",
                    "zoomoutup",
                    "bounceout",
                    "bounceoutdown",
                    "bounceoutleft",
                    "bounceoutright",
                    "bounceoutup",
                    "rotateout",
                    "rotateoutdownleft",
                    "rotateoutdownright",
                    "rotateoutupleft",
                    "rotateoutupright",

                    "swirloutfwd",
                    "swirloutfwdcenter",
                    "swirloutfwdleft",
                    "swirloutfwdright",
                    "swirloutfwdtop",
                    "swirloutbckbottom",
                    "swirloutbckcenter",
                    "swirloutbckleft",
                    "swirloutbckright",
                    "swirloutbcktop",
                ),
            ),
            "drugie"=>Array(
                "NAME"=>GetMessage("ANIMATEDGRAPHICS_GRUPP_DRUGIE"),
                "NAME2"=>GetMessage("ANIMATEDGRAPHICS_GRUPP_DRUGIE2"),
                "CODE_EFF"=> Array(

                ),
            ),
        );
        return $out;

    }
    static function getSelectBoxSingleEffectGrupp() {
        $ms=self::getGruppEffect();
        $out=Array();
        $out['allgrupp'] = GetMessage("ANIMATEDGRAPHICS_ALL_GRUPP");
        foreach($ms as $key=>$val) {
             if(count($val["CODE_EFF"])>0) {
                 $out[$key] = $val['NAME'];
             }
        }
        return $out;
    }

    static function getSelectBoxEffect() {
        /**
         * Статический перечень эффектов анимации для селектбокса Визуального редактора. Базовые Эффекты.
         */
        $out = Array(
            "circle_left" => GetMessage("ANIMATEDGRAPHICS_VRASHENIE_PROTIV"),
            "circle_right" => GetMessage("ANIMATEDGRAPHICS_VRASHENIE_PO"),
            "opacity_up" => GetMessage("ANIMATEDGRAPHICS_OPACITY_UP"),
            "opacity_down" => GetMessage("ANIMATEDGRAPHICS_OPACITY_DOWN"),
            "rotate_x" => GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_VRASENIE_POX"),
            "rotate_y" => GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_VRASENIE_POY"),

            "opacity_up_mnogo" => GetMessage("ANIMATEDGRAPHICS_OPACITY_UP_MNOGO"),
            "opacity_down_mnogo" => GetMessage("ANIMATEDGRAPHICS_OPACITY_DOWN_MNOGO"),
            "rotate_repspective_x_1" => GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_REPSPECTIVE_X_1"),
            "rotate_repspective_x_2" => GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_REPSPECTIVE_X_2"),
            "rotate_repspective_y_1" => GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_REPSPECTIVE_Y_1"),
            "rotate_repspective_y_2" => GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_REPSPECTIVE_Y_2"),
            "from_small_to_big" => GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_SMALL_TO_BIG"),
            "from_big_to_small" => GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_SMALL_TO_SMALL"),
            "wolna_eff" => GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_WOLNA"),
            "telefon" => GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_TELEFON"),

            "bg_left"=> GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_SDVIG_FONA_VLEVO"),
            "bg_right"=> GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_SDVIG_FONA_VPRAVO"),
        );
        return $out;
    }
    static function getAllEffectHelp() {
        /**
         * Вывод массива всех эффектов для popup окна подсказки при выборе эффекта
         * Входных параметров нет
         */
        $msGruppHelp = self::getHelpMsGrupp();
        $out = array_merge(
            Array("delimiterbase"=>GetMessage("ANIMATEDGRAPHICS_HELP_BASEEFFECT")),
            self::getSelectBoxEffect(),
            Array("delimitersingle"=>GetMessage("ANIMATEDGRAPHICS_HELP_SINGLEFFECT")),
            $msGruppHelp
        );
        return $out;
    }

    static function getHelpMsGrupp() {
        $msGr = self::getGruppEffect();
        $msAllSingleEff = self::getSelectBoxSingleEffect('allgrupp');
        foreach ($msGr as $key=>$val) {
            if(count($val['CODE_EFF'])>0) {
                $out["delimiter".$key] = $val["NAME2"];
                foreach ($val['CODE_EFF'] as $val2) {
                    $out[$val2] = $msAllSingleEff[$val2];
                }
            }
        }
        return $out;
    }

    static function  getInfinite($str, $up_down, $ms){
        /**
         * Формирование части css кода отвечающего за остановку или зацикливание анимации плюс параметр последнего стоп кадра
         *Количесвто итераций
         * @var string $str
         * Направление изменения свойства css- возрастает или убывает
         * @var string $up_down
         */
        if(isset($ms['FORWARD'])) {
            if($ms['FORWARD'] === 0) {
                $infinite = "1";
                return $infinite;
            }
        }
        $infinite = "infinite";
        /*
         * Некоторые эффеткты нужно фиксировать после завершения анимации
         * Недостаток - следующая анимация в цепочке может не сработать, так как анимация останется в статусе "Не завершена"
        */
        if(
            $up_down == 'opacity_up' ||
            $up_down == 'opacity_down'
        ) {
            $infinite = "1 forwards";
        }else {
            if(isset($str)) {
                $inf = trim($str);
                if(strlen($inf)>0) {
                    $inf = (int)$inf;
                    if($inf>0) {
                        $infinite = $inf;
                    }
                }
            }

        }
        return $infinite;
    }
    static function getZad($str) {
        /**
         * Получение параметра и обработка ошибок ввода параметра компонента
         * @var string $str
         */
        $zad = 0;
        if(isset($str)) {
            $inf = trim($str);
            if(strlen($inf)>0) {
                $inf = (float)$inf;
                if($inf>0) {
                    $zad = $inf;
                }
            }
        }
        return $zad;

    }
    static function getSpeed($str) {
        /**
         * Получение параметра и обработка ошибок ввода параметра компонента
         * @var string $str
         */
        $speed = 1;
        if(isset($str)) {
            $inf = trim($str);
            if(strlen($inf)>0) {
                $inf = (float)$inf;
                if($inf>0) {
                    $speed  = $inf;
                }
            }
        }
        return $speed;

    }

    static function  getOpasity($str) {
        /**
         * Получение параметра и обработка ошибок ввода параметра компонента
         * @var string $str
         */
        $opa = "";
        if(isset($str)) {
            $inf = trim($str);
            if(strlen($inf)>0) {
                if($inf == 'opacity_up') {
                    $opa = "opacity:0;";
                }
                if($inf == 'opacity_down') {
                    $opa = "opacity:1;";
                }
            }
        }
        return $opa;
    }
    static function selectorParamPlosk($iz,$arParams,$arParams_0,$iz_new) {
        /*
          * Накопительная обработка плоского массива
       */
        $out = $arParams;
        foreach($arParams_0 as $key=>$val) {
            $first = mb_substr($key,0,1);
            if($first == "~") {
                continue;
            }
            $rr = trim($key);
            $rr = preg_replace("/^[\D]+/","",$rr);
            $rr = trim($rr);
            if(strlen($rr)>0) {
                $rr = (int)$rr;
                if($rr === $iz) {
                    $newKey = preg_replace("/\d/","",$key);
                    $out[trim($newKey).$iz_new] = $val;
                }
            }
        }
        return $out;
    }

    static function selectorParam($iz,$arParams) {
        /**
         * Разовая
         * Для Итогового  массива входных параметров
         * счетчик элементов
         * @var int $iz
         * Входной массив
         * @var array $arParams
         */

        $out= Array();
        $ms_effect = Array();
        foreach($arParams as $key=>$val) {
            $first = mb_substr($key,0,1);
            if($first == "~") {
                continue;
            }
            $rr = trim($key);
            $rr = preg_replace("/^[\D]+/","",$rr);
            $newKey = preg_replace("/\d/","",$key);

            $rr = trim($rr);
            if (strlen($rr) > 0) {
                $rr = (int)$rr;
                if ($rr === $iz) {
                    if($newKey == 'EFFECT') {
                        $ms_effect = $val;
                    }

                }
            }
        }
        if(!isset($arParams['EFFECT'.$iz])) {
            if(isset($arParams['SINGLE_EFFECT_CH'.$iz])) {
                if($arParams['SINGLE_EFFECT_CH'.$iz] == "Y") {
                    $arParams['EFFECT'.$iz]=Array("noeffect".$iz);
                    $ms_effect=Array("noeffect".$iz);
                }
            }
        }
        $i_eff = 0;


        foreach($ms_effect as $eff) {
            foreach ($arParams as $key => $val) {
                $first = mb_substr($key, 0, 1);
                if ($first == "~") {
                    continue;
                }
                $rr = trim($key);
                $rr = preg_replace("/^[\D]+/", "", $rr);
                $newKey = preg_replace("/\d/", "", $key);
                $rr = trim($rr);
                if (strlen($rr) > 0) {
                    $rr = (int)$rr;
                    if ($rr === $iz) {
                        if($newKey == 'EFFECT') {
                            $ms_effect = $val;
                            $out[$i_eff][$newKey] = $eff;
                            $out[$i_eff][trim($key)] = $val;
                        }else {
                            $out[$i_eff][$newKey] = $val;
                            $out[$i_eff][trim($key)] = $val;
                        }


                    }
                }
            }
            $i_eff++;
        }

        return $out;
    }
    static function selectorParamGrupp($iz,$arParams,$arParams_0,$iz_new) {
        /**
         * Накопительная групповой селектор
         * Для Итогового  массива входных параметров
         * счетчик элементов
         * @var int $iz
         * Входной массив промежуточный
         * @var array $arParams
         * Входной массив исходный
         * @var array $arParams_0
         * Накопительный итератор
         * @var int $iz_new
         */
        $out = $arParams;
        $iz_out = $iz_new;
        $i_col=0;
        $iMnojitel=0;
        $ms_class = explode(",", $arParams_0["CLASS_OR_ID".$iz]);
        foreach($ms_class as $val) {
            /**/
            if($i_col>0) {
                $iz_out++;
            }
            $class= trim($val);
            if(strlen($class)>0) {
                foreach($arParams_0 as $key=>$val_2) {
                    $first = mb_substr($key,0,1);
                    if($first == "~") {
                        continue;
                    }

                    $rr = trim($key);
                    $rr = preg_replace("/^[\D]+/","",$rr);
                    $rr = trim($rr);
                    if(strlen($rr)>0) {
                        $rr = (int)$rr;
                        if($rr === $iz) {
                            $newKey = preg_replace("/\d/","",$key);
                            $out[trim($newKey).$iz_out] = $val_2;
                            if($newKey == 'START_ZADERJKA') {
                                $z =  $arParams_0["ZADERJKA_ZW".$iz];
                                $z = (float)$z;
                                $z2 =  $arParams_0["START_ZADERJKA".$iz];
                                $z2 = (float)$z2;
                                $rzZaderjkaGrupp = $z2 + $iMnojitel*$z;
                                $out["START_ZADERJKA".$iz_out] = $rzZaderjkaGrupp;
                                $iMnojitel++;
                            }
                            $out["CLASS_OR_ID".$iz_out] = $class;
                            $i_col++;
                        }
                    }
                }
            }
            /**/
        }

        return Array($out,$iz_out);
    }
    static function inplodeTrasform($ms_iz) {
        $out=Array();
        $idd2 = 0;
        $idd3 = 0;
        foreach($ms_iz as $key2=>$val2) {
            $ms_complex = Array();
            $iz = -1;
            $ms_compare=Array();
            foreach($val2 as $val3) {/*0*/
                $iz++;
                if(in_array($iz, $ms_compare)) {
                    continue;
                }

                if(
                    ($val3['EFFECT'] == 'circle_left' ||
                        $val3['EFFECT'] == 'circle_right' ||
                        $val3['EFFECT'] == 'rotate_x' ||
                        $val3['EFFECT'] == 'rotate_y' ||
                        $val3['EFFECT'] == 'from_small_to_big' ||
                        $val3['EFFECT'] == 'from_big_to_small' ||
                        $val3['EFFECT'] == 'telefon' ||
                        $val3['EFFECT'] == 'rotate_repspective_x_1' ||
                        $val3['EFFECT'] == 'rotate_repspective_x_2' ||
                        $val3['EFFECT'] == 'rotate_repspective_y_1' ||
                        $val3['EFFECT'] == 'rotate_repspective_y_2'

                    ) &&
                    ($val3['STOP_COUNT']=="" || $val3['STOP_COUNT']=="0") &&
                    $val3['SINGLE_EFFECT_CH'] <> "Y"
                )
                {
                    $fl_comlex = 0;
                    $effect_comlex = "";
                    $iw = -1;
                    foreach($val2 as $val4) {/* ПРоверка ниже и накопление */
                        $iw ++;
                        if($iw<=$iz) {
                            continue;
                        }

                        if(
                            ($val4['EFFECT'] == 'circle_left' ||
                                $val4['EFFECT'] == 'circle_right' ||
                                $val4['EFFECT'] == 'rotate_x' ||
                                $val4['EFFECT'] == 'rotate_y' ||
                                $val4['EFFECT'] == 'from_small_to_big' ||
                                $val4['EFFECT'] == 'from_big_to_small' ||
                                $val4['EFFECT'] == 'telefon' ||

                                $val4['EFFECT'] == 'rotate_repspective_x_1' ||
                                $val4['EFFECT'] == 'rotate_repspective_x_2' ||
                                $val4['EFFECT'] == 'rotate_repspective_y_1' ||
                                $val4['EFFECT'] == 'rotate_repspective_y_2'
                            ) &&
                            ($val4['STOP_COUNT']=="" || $val4['STOP_COUNT']=="0") &&
                            $val4['SINGLE_EFFECT_CH'] <> "Y"
                        )
                        {
                            $ms_compare[] = $iw;
                            $fl_comlex = 1;
                            if(strlen($effect_comlex)===0) {
                                $effect_comlex =$val3['EFFECT']."_".$val4['EFFECT'];
                            }else {
                                $effect_comlex =$effect_comlex."_".$val4['EFFECT'];
                            }

                        }

                    }
                    /**/
                    if($fl_comlex === 1) {
                        $ms_complex= $val3;
                        $ms_complex['EFFECT'] = $effect_comlex;
                        $out[$key2][$idd3] = $ms_complex;
                    }else {
                        $out[$key2][$idd3] = $val3;
                    }
                    /**/

                }else {
                    $out[$key2][$idd3] = $val3;
                }
                $idd3++;
            }
            $idd2++;
        }


        return $out;
    }
    static function checkForvard($ms_iz) {

        foreach($ms_iz as $key=>$val) {
            $fl_add = 0;

            foreach($val as $val2) {
                if(isset($val2['EFFECT'])) {
                    if($val2['EFFECT'] == 'opacity_up_mnogo' || $val2['EFFECT'] == 'opacity_down_mnogo'){
                        $iz=0;
                        foreach($val as $val3) {
                            if($val3['EFFECT'] == 'opacity_up' || $val3['EFFECT'] == 'opacity_down'){
                                $ms_iz[$key][$iz]['FORWARD'] = 0;
                            }
                            $iz++;
                        }

                    }
                }

            }

        }
        return $ms_iz;
    }

    static function iplSingleEffect($ms_iz) {
        /**
         * Пересборка массива для одиночных эффектов
         * Входной массив исходный
         * @var array $ms_iz
         */

        foreach($ms_iz as $key=>$val) {
            $iz=0;
            $msTmp = Array();
            $msTmp1 = Array();
            $msTmp2 = Array();
            $flS_0 = 0;
            foreach($val as $val2) {
                $flS = 0;
                if(isset($val2['SINGLE_EFFECT_CH'])) {
                    if($val2['SINGLE_EFFECT_CH'] == "Y") {
                        $flS = 1;
                        if($flS_0 === 0) {
                            $msTmp1[] = $val2;
                        }
                        $flS_0 = 1;
                    }
                }
                if($flS === 0) {
                    $msTmp2[] = $val2;
                }
                $iz++;
            }
            $ms_iz[$key] = array_merge($msTmp1,$msTmp2);

        }
        return $ms_iz;
    }

    static function prepareMs($arParams_0){
        /**
         * Подготовка исходного массива Основная функция
         * Входной массив исходный
         * @var array $arParams_0
         */
        $arParams=Array();
        $out = Array();
        $ms_iz=Array();
        $ms_dbl = Array();
        $imax = 1;
        if(isset($arParams_0["ALL_BLOK"])){
            $rr = trim($arParams_0["ALL_BLOK"]);
            if(strlen($rr)>0){
                $rr = preg_replace("/\D/","",$rr);
                $rr = (int)$rr;
                if($rr>0) {
                    $imax = $rr;
                }
            }
        }
        $iz = 1;
        $iz_2 = 1;
        $iz_new = 0;
        if($iz>0) {
            /*Делаю "плоский" массив*/
            for($iz =1;$iz<=$imax;$iz++) {
                $fl_grupp = 0;
                $fl_len = 0;
                if(isset($arParams_0["CLASS_OR_ID".$iz])) {
                    $str = trim($arParams_0["CLASS_OR_ID".$iz]);
                    if(strlen($str)>0) {
                        $fl_len = 1;
                        $ms_class = explode(",", $arParams_0["CLASS_OR_ID".$iz]);
                        if(count($ms_class)>1) {
                            $fl_grupp = 1;
                        }
                    }
                }

                if($fl_len === 1 && $fl_grupp === 0) {
                    $iz_new++;
                    $arParams = self::selectorParamPlosk($iz,$arParams,$arParams_0,$iz_new);
                }
                if($fl_len === 1 && $fl_grupp === 1) {
                    $iz_new++;
                    $msP = self::selectorParamGrupp($iz,$arParams,$arParams_0,$iz_new);
                    $arParams = $msP[0];
                    $iz_new = $msP[1];
                }
            }

            $arParams_0["ALL_BLOK"] = $iz_new;
            $imax = $iz_new;
            $iz = 1;
            $iz_2 = 1;

            for($iz =1;$iz<=$imax;$iz++) {
                $selector = "";
                $fl_stop = 1;
                $fl_gruppa = 0;
                if (isset($arParams['CLASS_OR_ID' . $iz])) {
                    $selector = trim($arParams['CLASS_OR_ID' . $iz]);
                    if (strlen($selector) > 0) {
                        $fl_stop = 0;
                    }
                }
                if($fl_stop === 1) {
                    continue;
                }
                if(in_array($iz, $ms_dbl)) {
                    continue;
                }
                $msEff = self::selectorParam($iz,$arParams);
                foreach ($msEff as $eff_all) {
                    $ms_iz[$selector][] = $eff_all;
                }

                $inext = $iz+1;
                $iz_2 = $inext;
                for($iz_2 = $inext;$iz_2<=$imax;$iz_2++) {
                    $fl_stop_2 = 1;
                    $selector_2 = "";
                    if (isset($arParams['CLASS_OR_ID' . $iz_2])) {
                        $selector_2 = trim($arParams['CLASS_OR_ID' . $iz_2]);
                        if (strlen($selector_2) > 0) {
                            $fl_stop_2 = 0;
                        }
                    }
                    if($fl_stop_2 === 1) {
                        continue;
                    }
                    if($selector == $selector_2) {
                        $ms_dbl[] = $iz_2;
                        $msEff = self::selectorParam($iz_2,$arParams);
                        foreach ($msEff as $eff_all) {
                            $ms_iz[$selector][] = $eff_all;
                        }


                    }
                }
            }
        }
        /*Объединяю эффекты transform*/

        $ms_iz = self::inplodeTrasform($ms_iz);
        /* ПРозрачность убрать forward*/
        $ms_iz = self::checkForvard($ms_iz);
        /* Склеиваю массив для одиночных эффектов */
        //$ms_iz = self::iplSingleEffect($ms_iz);
        $out = Array($ms_iz,$arParams);
        return $out;
    }
    static function generateHelpCssStart() {
        $str = self::getStyle_start(Array(), "",1);
        $str = str_replace("\r\n", "",$str);
        $str = str_replace("\n", "",$str);
        $str = str_replace("\r", "",$str);
        $str = str_replace("  ", "",$str);
        file_put_contents($_SERVER['DOCUMENT_ROOT']."/bitrix/components/burcomp/animatedgraphics.grafika.list/settings/forhelp.css",$str);
        return true;
    }

    static function generateHelpCss() {
        /**
         * Генерация файла CSS для popup окна подсказки при выборе эффекта в компоненте
         * Входных параметров нет. Выполняется однократно разрабочиком только при добавлении новых эффектов
         */
        $msAllEffect = self::getAllEffectHelp();
        $msPrepare = Array();
        $msSingle = self::getSelectBoxSingleEffect('allgrupp');
        $msSingle2=Array();
        foreach($msSingle as $key=>$val) {
            $msSingle2[]=$key;
        }
        $flPar = 0;
        foreach($msAllEffect as $key=>$val) {
            $iw = 1;
            $speed = 1.2;
            if($key == 'opacity_up' ||
                $key == 'opacity_down' ||
                $key == 'opacity_up_mnogo' ||
                $key == 'opacity_down_mnogo'
            ) {
                $speed = 1;
            }
            if($key == 'telefon' ||
                $key == 'wolna_eff' ||
                $key == 'flip1' ||
                $key == 'rubber' ||
                $key == 'bounce'

            )
            {
                $speed = 1.2;
            }
            if($key == 'speedin') {
                $speed = 0.8;
            }
            if($key == 'bounceballbottom') {
                $speed = 2;
            }
            if($key == 'bg_left' || $key == 'bg_right') {
                $speed = 44;
            }
            for($iw = 1;$iw<=2;$iw++) {
                if($iw === 1) {
                    $cls = $key;
                    $stop = 0;
                }else {
                    $stop = 1;
                    $cls = $key."_stop";
                }
                $msPrepare["." . $cls][0]["CLASS_OR_ID"] = "." . $cls;
                $msPrepare["." . $cls][0]["COLOR_ID"] = '#4494d7';
                $msPrepare["." . $cls][0]["EFFECT"] = $key;
                if($flPar === 0 && $key == 'rotate_repspective_x_1') {
                    $msPrepare["." . $cls][0]["PARENT_ID"] = ".jcol-2-persp";
                    $flPar = 1;
                }else {
                    $msPrepare["." . $cls][0]["PARENT_ID"] = "";
                }

                $msPrepare["." . $cls][0]["SINGLE_EFFECT_CH"] = "N";
                if (in_array($key, $msSingle2)) {
                    $msPrepare["." . $cls][0]["SINGLE_EFFECT_CH"] = "Y";
                }
                $msPrepare["." . $cls][0]["SINGLE_EFFECT_LIST"] = $key;
                $msPrepare["." . $cls][0]["SPEED"] = $speed;
                $msPrepare["." . $cls][0]["START_ZADERJKA"] = 0;
                $msPrepare["." . $cls][0]["STOP_COUNT"] = $stop;
                $msPrepare["." . $cls][0]["ZADERJKA_ZW"] = 0;
            }

        }

        return $msPrepare;
    }

    static function getParamComponent($currentVal){
        /**
         * Генерация входных параметров компонента. Только Для визуального редактора
         * Входной массив исходный текущие значения параметров компонента
         * @var array $currentVal
         */
        $out=Array();
        /**/
        $iz_max=COption::GetOptionString('directoriya.animatedgraphics', 'max_pic');
        $iz=1;
        $i_dell=0;
        $out = array();
        $all_blok = 1;
        $fl_koleso = 0;
        $fl_newyear = 0;
        if(isset($_REQUEST["component_template"])) {
            if($_REQUEST["component_template"] == 'koleso') {
                $fl_koleso = 1;
            }
            if($_REQUEST["component_template"] == 'newyear') {
                $fl_newyear = 1;
            }

        }
        if(isset($currentVal["COMPONENT_TEMPLATE"])){
            if ($currentVal["COMPONENT_TEMPLATE"] == 'koleso') {
                $fl_koleso = 1;
            }
            if ($currentVal["COMPONENT_TEMPLATE"] == 'newyear') {
                $fl_newyear = 1;
            }
        }

        if(isset($currentVal["ALL_BLOK"])) {
            if(strlen($currentVal["ALL_BLOK"])>0) {
                $all_blok = $currentVal["ALL_BLOK"];
                $all_blok = (int)$all_blok;
                if($all_blok<1) {
                    $all_blok=1;
                }
            }
        }
        if($fl_koleso === 1) {
            if($all_blok<7) {
                $all_blok=7;
            }
        }
        if($fl_newyear === 1) {
            if($all_blok<2) {
                $all_blok=2;
            }
        }

        for($iz=1;$iz<=$iz_max;$iz++) {
            if ( ($iz<=$all_blok && $iz>1) || $iz===1) {
                $out["GROUPS"]["BASE" . $iz] = array("NAME" => $currentVal["DSPIC".$iz]." ".GetMessage("ANIMATEDGRAPHICS_GRUPPA_PARAM_PIC_N") . $iz, "SORT" => (150 + $iz));
                if($iz === 1){
                    $out["PARAMETERS"]["PREFIX_CLASS"] =
                        array(
                            "PARENT" => "BASE" . $iz,
                            "NAME" => GetMessage("ANIMATEDGRAPHICS_RAND_PREFIX_CLASS_COMPONENT"),
                            "TYPE" => "STRING",
                            "MULTIPLE" => "N",
                            "DEFAULT" => randString(8, array("abcdefghijknmopqrstuvwxyz")),
                            "COLS" => 25,
                            "HIDDEN"=>"Y"
                        );
                    /**/

                    if($fl_koleso === 1) {
                        $out["PARAMETERS"]["ALL_BLOK"] =
                            array(
                                "PARENT" => "BASE" . $iz,
                                "NAME" => GetMessage("ANIMATEDGRAPHICS_TOTAL_PIC_BLOCK"),
                                "TYPE" => "STRING",
                                "MULTIPLE" => "N",
                                "DEFAULT" => "7",
                                "COLS" => 1,
                                "REFRESH" => 'Y'
                            );
                    }else {
                        $out["PARAMETERS"]["ALL_BLOK"] =
                            array(
                                "PARENT" => "BASE" . $iz,
                                "NAME" => GetMessage("ANIMATEDGRAPHICS_TOTAL_PIC_BLOCK"),
                                "TYPE" => "STRING",
                                "MULTIPLE" => "N",
                                "DEFAULT" => "1",
                                "COLS" => 1,
                                "REFRESH" => 'Y'
                            );
                    }

                    /**/
                }

                $def = "";
                if($iz===1){
                    $def = GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_POKRYSKA");
                }
                $out["PARAMETERS"]["DSPIC" . $iz] =
                    array(
                        "PARENT" => "BASE" . $iz,
                        "NAME" => GetMessage("ANIMATEDGRAPHICS_PYASNENIE_K_ANIMACII"),
                        "TYPE" => "STRING",
                        "MULTIPLE" => "N",
                        "DEFAULT" => $def,
                        "COLS" => 25
                    );
                $def = "";
                if($iz===1){
                    $def = ".p-pokrishka";
                }
                $out["PARAMETERS"]["CLASS_OR_ID" . $iz] =
                    array(
                        "PARENT" => "BASE" . $iz,
                        "NAME" => GetMessage("ANIMATEDGRAPHICS_CLASS_OR_ID_HTML_TEGA"),
                        "TYPE" => "STRING",
                        "MULTIPLE" => "N",
                        "DEFAULT" => $def,
                        "COLS" => 25
                    );

                $def = 0;
                if($iz===1){
                    $def = 3;
                }
                $out["PARAMETERS"]["START_ZADERJKA" . $iz] =
                    array(
                        "PARENT" => "BASE" . $iz,
                        "NAME" => GetMessage("ANIMATEDGRAPHICS_ZADERKA_FROM_SEC"),
                        "TYPE" => "STRING",
                        "MULTIPLE" => "N",
                        "DEFAULT" => $def,
                        "COLS" => 5
                    );
                $out["PARAMETERS"]["ZADERJKA_ZW" . $iz] =
                    array(
                        "PARENT" => "BASE" . $iz,
                        "NAME" => GetMessage("ANIMATEDGRAPHICS_ZADERJKA_ZW_ELEM_GRUPP"),
                        "TYPE" => "STRING",
                        "MULTIPLE" => "N",
                        "DEFAULT" => "1",
                        "COLS" => 5
                    );
                $out["PARAMETERS"]["SPEED" . $iz] =
                    array(
                        "PARENT" => "BASE" . $iz,
                        "NAME" => GetMessage("ANIMATEDGRAPHICS_SKOROST_ANIMATE_SEC"),
                        "TYPE" => "STRING",
                        "MULTIPLE" => "N",
                        "DEFAULT" => "8",
                        "COLS" => 5
                    );
                $out["PARAMETERS"]["STOP_COUNT" . $iz] =
                    array(
                        "PARENT" => "BASE" . $iz,
                        "NAME" => GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_KOLICESTVO_POVTORENI"),
                        "TYPE" => "STRING",
                        "MULTIPLE" => "N",
                        "DEFAULT" => "",
                        "COLS" => 5
                    );
                $fl_single=0;
                if(isset($_REQUEST['current_values']['SINGLE_EFFECT_CH'.$iz])) {
                    if($_REQUEST['current_values']['SINGLE_EFFECT_CH'.$iz] == "Y") {
                        $fl_single=1;
                    }
                }
                if( $currentVal["SINGLE_EFFECT_CH".$iz] == "Y" || $fl_single===1){
                    $fl_single=1;
                }
                $out["PARAMETERS"]["SINGLE_EFFECT_CH" . $iz] =
                    array(
                        "PARENT" => "BASE" . $iz,
                        "NAME" => GetMessage("INFOGRAFIKA_SINGLE_EFFECT_CH"),
                        "TYPE" => "CHECKBOX",
                        "DEFAULT" => "N",
                        "REFRESH" => "Y",
                    );
                if($fl_single === 0) {
                    $out["PARAMETERS"]["EFFECT" . $iz] =
                        array(
                            "PARENT" => "BASE" . $iz,
                            "NAME" => GetMessage("ANIMATEDGRAPHICS_EFFECTI"),
                            "TYPE" => "LIST",
                            "ADDITIONAL_VALUES" => "N",
                            "VALUES" => self::getSelectBoxEffect(),
                            "REFRESH" => "N",
                            "DEFAULT" => "circle_right",
                            "MULTIPLE" => "Y",
                            "SIZE" => 5
                        );
                }else {
                    $grupp = 'allgrupp';
                    $fl_gr=0;
                    if(isset($currentVal["SINGLE_EFFECT_GRUPP" . $iz])) {
                        if(strlen($currentVal["SINGLE_EFFECT_GRUPP" . $iz])>0) {
                            $grupp = $currentVal["SINGLE_EFFECT_GRUPP" . $iz];
                            $fl_gr=1;
                        }
                    }
                    if($fl_gr === 0 && isset($_REQUEST['current_values']['SINGLE_EFFECT_GRUPP'.$iz]) ) {
                        $grupp = $_REQUEST['current_values']['SINGLE_EFFECT_GRUPP'.$iz];
                    }
                    $out["PARAMETERS"]["SINGLE_EFFECT_GRUPP" . $iz] =
                        array(
                            "PARENT" => "BASE" . $iz,
                            "NAME" => GetMessage("INFOGRAFIKA_SINGLE_EFFECT_GRUPP"),
                            "TYPE" => "LIST",
                            "ADDITIONAL_VALUES" => "N",
                            "VALUES" => self::getSelectBoxSingleEffectGrupp(),
                            "REFRESH" => "Y",
                            "DEFAULT" => "allgrupp",
                            "MULTIPLE" => "N",
                            "SIZE" => 4
                        );
                    $out["PARAMETERS"]["SINGLE_EFFECT_LIST" . $iz] =
                        array(
                            "PARENT" => "BASE" . $iz,
                            "NAME" => GetMessage("INFOGRAFIKA_SINGLE_EFFECT_LIST"),
                            "TYPE" => "LIST",
                            "ADDITIONAL_VALUES" => "N",
                            "VALUES" => self::getSelectBoxSingleEffect($grupp),
                            "REFRESH" => "N",
                            "DEFAULT" => "",
                            "MULTIPLE" => "N",
                            "SIZE" => 10
                        );
                }
                /**/
                $out["PARAMETERS"]["COL_SCR" . $iz] = array(
                    'NAME' => GetMessage("ANIMATEDGRAPHICS_SYSTEM_TPL"),
                    'TYPE' => 'CUSTOM',
                    'JS_FILE' => '/bitrix/components/burcomp/animatedgraphics.grafika.list/settings/settings.js',
                    'JS_EVENT' => 'colTpl',
                    'JS_DATA' => LANGUAGE_ID."||".GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_HELP_BUTTON_TEXT")."||ALLTPL||".$iz."||".(defined('BX_UTF') && BX_UTF == true ? 'true' : 'false'),
                    'DEFAULT' => "1",
                    "PARENT" => "BASE" . $iz,
                    "HIDDEN"=>"N"
                );

                $def = "";
                $out["PARAMETERS"]["PARENT_ID" . $iz] =
                    array(
                        "PARENT" => "BASE" . $iz,
                        "NAME" => GetMessage("ANIMATEDGRAPHICS_CLASS_OR_ID_HTML_TEGA_PARENT"),
                        "TYPE" => "STRING",
                        "MULTIPLE" => "N",
                        "DEFAULT" => $def,
                        "COLS" => 25
                    );

                $def = "#4494d7";
                $out["PARAMETERS"]["COLOR_ID" . $iz] =
                    array(
                        "PARENT" => "BASE" . $iz,
                        "NAME" => GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_WOLNA_COLOR"),
                        "TYPE" => "COLORPICKER",
                        "DEFAULT" => $def

                    );
                $def = "Y";
                $out["PARAMETERS"]["VOLNA_OPASITY_CH" . $iz] =
                    array(
                        "PARENT" => "BASE" . $iz,
                        "NAME" => GetMessage("ANIMATEDGRAPHICS_VOLNA_OPASITY_CH"),
                        "TYPE" => "CHECKBOX",
                        "DEFAULT" => $def,
                        "REFRESH" => "N",
                    );

                $def = "";
                $out["PARAMETERS"]["DOP_STYLE" . $iz] =
                    array(
                        "PARENT" => "BASE" . $iz,
                        "NAME" => GetMessage("ANIMATEDGRAPHICS_DOP_STYLE"),
                        "TYPE" => "STRING",
                        "MULTIPLE" => "N",
                        "DEFAULT" => $def,
                        "COLS" => 25
                );

                /**/

            }



        }
        if($fl_koleso === 1) {
            $ms_def = self::repare_for_tpl(Array());
            for($iz=1;$iz<=$all_blok;$iz++) {
                $out["PARAMETERS"]["DSPIC" . $iz] =
                    array(
                        "PARENT" => "BASE" . $iz,
                        "NAME" => GetMessage("ANIMATEDGRAPHICS_PYASNENIE_K_ANIMACII"),
                        "TYPE" => "STRING",
                        "MULTIPLE" => "N",
                        "DEFAULT" => $ms_def["DSPIC" . $iz],
                        "COLS" => 25
                    );
                $out["PARAMETERS"]["CLASS_OR_ID" . $iz] =
                    array(
                        "PARENT" => "BASE" . $iz,
                        "NAME" => GetMessage("ANIMATEDGRAPHICS_CLASS_OR_ID_HTML_TEGA"),
                        "TYPE" => "STRING",
                        "MULTIPLE" => "N",
                        "DEFAULT" => $ms_def["CLASS_OR_ID" . $iz],
                        "COLS" => 25
                    );
                if($iz>7) {
                    $def = 0;
                }else {
                    $def = $ms_def["START_ZADERJKA" . $iz];
                }
                $out["PARAMETERS"]["START_ZADERJKA" . $iz] =
                    array(
                        "PARENT" => "BASE" . $iz,
                        "NAME" => GetMessage("ANIMATEDGRAPHICS_ZADERKA_FROM_SEC"),
                        "TYPE" => "STRING",
                        "MULTIPLE" => "N",
                        "DEFAULT" => $def,
                        "COLS" => 5
                    );
                if($iz>7) {
                    $def = 1;
                }else {
                    $def = $ms_def["ZADERJKA_ZW" . $iz];
                }
                $out["PARAMETERS"]["ZADERJKA_ZW" . $iz] =
                    array(
                        "PARENT" => "BASE" . $iz,
                        "NAME" => GetMessage("ANIMATEDGRAPHICS_ZADERJKA_ZW_ELEM_GRUPP"),
                        "TYPE" => "STRING",
                        "MULTIPLE" => "N",
                        "DEFAULT" => $def,
                        "COLS" => 5
                    );
                if($iz>7) {
                    $def = 8;
                }else {
                    $def = $ms_def["SPEED" . $iz];
                }
                $out["PARAMETERS"]["SPEED" . $iz] =
                    array(
                        "PARENT" => "BASE" . $iz,
                        "NAME" => GetMessage("ANIMATEDGRAPHICS_SKOROST_ANIMATE_SEC"),
                        "TYPE" => "STRING",
                        "MULTIPLE" => "N",
                        "DEFAULT" => $def,
                        "COLS" => 5
                    );
                if($iz>7) {
                    $def = "";
                }else {
                    $def = $ms_def["STOP_COUNT" . $iz];
                }
                $out["PARAMETERS"]["STOP_COUNT" . $iz] =
                    array(
                        "PARENT" => "BASE" . $iz,
                        "NAME" => GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_KOLICESTVO_POVTORENI"),
                        "TYPE" => "STRING",
                        "MULTIPLE" => "N",
                        "DEFAULT" => $def,
                        "COLS" => 5
                    );

                if($iz>7) {
                    $def = "circle_right";
                }else {
                    $def = $ms_def["EFFECT" . $iz];
                }
                $out["PARAMETERS"]["EFFECT" . $iz] =
                    array(
                        "PARENT" => "BASE" . $iz,
                        "NAME" => GetMessage("ANIMATEDGRAPHICS_EFFECTI"),
                        "TYPE" => "LIST",
                        "ADDITIONAL_VALUES" => "N",
                        "VALUES" => self::getSelectBoxEffect(),
                        "REFRESH" => "N",
                        "DEFAULT" => $def,
                        "MULTIPLE" => "Y",
                        "SIZE" => 5
                    );
                $out["PARAMETERS"]["COL_SCR" . $iz] = array(
                    'NAME' => GetMessage("ANIMATEDGRAPHICS_SYSTEM_TPL"),
                    'TYPE' => 'CUSTOM',
                    'JS_FILE' => '/bitrix/components/burcomp/animatedgraphics.grafika.list/settings/settings.js',
                    'JS_EVENT' => 'colTpl',
                    'JS_DATA' => LANGUAGE_ID."||".GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_HELP_BUTTON_TEXT")."||KOLESO||".$iz."||".(defined('BX_UTF') && BX_UTF == true ? 'true' : 'false'),
                    'DEFAULT' => "2",
                    "PARENT" => "BASE" . $iz,
                    "HIDDEN"=>"N"
                );

            }

        }
        if($fl_newyear === 1) {
            $ms_def = self::repare_for_tpl_newyear(Array());
            for($iz=1;$iz<=$all_blok;$iz++) {
                $out["PARAMETERS"]["DSPIC" . $iz] =
                    array(
                        "PARENT" => "BASE" . $iz,
                        "NAME" => GetMessage("ANIMATEDGRAPHICS_PYASNENIE_K_ANIMACII"),
                        "TYPE" => "STRING",
                        "MULTIPLE" => "N",
                        "DEFAULT" => $ms_def["DSPIC" . $iz],
                        "COLS" => 25
                    );
                $out["PARAMETERS"]["CLASS_OR_ID" . $iz] =
                    array(
                        "PARENT" => "BASE" . $iz,
                        "NAME" => GetMessage("ANIMATEDGRAPHICS_CLASS_OR_ID_HTML_TEGA"),
                        "TYPE" => "STRING",
                        "MULTIPLE" => "N",
                        "DEFAULT" => $ms_def["CLASS_OR_ID" . $iz],
                        "COLS" => 25
                    );
                if($iz>2) {
                    $def = 0;
                }else {
                    $def = $ms_def["START_ZADERJKA" . $iz];
                }
                $out["PARAMETERS"]["START_ZADERJKA" . $iz] =
                    array(
                        "PARENT" => "BASE" . $iz,
                        "NAME" => GetMessage("ANIMATEDGRAPHICS_ZADERKA_FROM_SEC"),
                        "TYPE" => "STRING",
                        "MULTIPLE" => "N",
                        "DEFAULT" => $def,
                        "COLS" => 5
                    );
                if($iz>2) {
                    $def = 1;
                }else {
                    $def = $ms_def["ZADERJKA_ZW" . $iz];
                }
                $out["PARAMETERS"]["ZADERJKA_ZW" . $iz] =
                    array(
                        "PARENT" => "BASE" . $iz,
                        "NAME" => GetMessage("ANIMATEDGRAPHICS_ZADERJKA_ZW_ELEM_GRUPP"),
                        "TYPE" => "STRING",
                        "MULTIPLE" => "N",
                        "DEFAULT" => $def,
                        "COLS" => 5
                    );
                if($iz>2) {
                    $def = 8;
                }else {
                    $def = $ms_def["SPEED" . $iz];
                }
                $out["PARAMETERS"]["SPEED" . $iz] =
                    array(
                        "PARENT" => "BASE" . $iz,
                        "NAME" => GetMessage("ANIMATEDGRAPHICS_SKOROST_ANIMATE_SEC"),
                        "TYPE" => "STRING",
                        "MULTIPLE" => "N",
                        "DEFAULT" => $def,
                        "COLS" => 5
                    );
                if($iz>2) {
                    $def = "";
                }else {
                    $def = $ms_def["STOP_COUNT" . $iz];
                }
                $out["PARAMETERS"]["STOP_COUNT" . $iz] =
                    array(
                        "PARENT" => "BASE" . $iz,
                        "NAME" => GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_KOLICESTVO_POVTORENI"),
                        "TYPE" => "STRING",
                        "MULTIPLE" => "N",
                        "DEFAULT" => $def,
                        "COLS" => 5
                    );

                if($iz>2) {
                    $def = "circle_right";
                }else {
                    $def = $ms_def["EFFECT" . $iz];
                }
                $out["PARAMETERS"]["EFFECT" . $iz] =
                    array(
                        "PARENT" => "BASE" . $iz,
                        "NAME" => GetMessage("ANIMATEDGRAPHICS_EFFECTI"),
                        "TYPE" => "LIST",
                        "ADDITIONAL_VALUES" => "N",
                        "VALUES" => self::getSelectBoxEffect(),
                        "REFRESH" => "N",
                        "DEFAULT" => $def,
                        "MULTIPLE" => "Y",
                        "SIZE" => 5
                    );
                $out["PARAMETERS"]["COL_SCR" . $iz] = array(
                    'NAME' => GetMessage("ANIMATEDGRAPHICS_SYSTEM_TPL"),
                    'TYPE' => 'CUSTOM',
                    'JS_FILE' => '/bitrix/components/burcomp/animatedgraphics.grafika.list/settings/settings.js',
                    'JS_EVENT' => 'colTpl',
                    'JS_DATA' => LANGUAGE_ID."||".GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_HELP_BUTTON_TEXT")."||NEWYEAR||".$iz."||".(defined('BX_UTF') && BX_UTF == true ? 'true' : 'false'),
                    'DEFAULT' => "3",
                    "PARENT" => "BASE" . $iz,
                    "HIDDEN"=>"N"
                );

            }



        }
        $out["PARAMETERS"]["CACHE_TIME"] = Array("DEFAULT"=>"0");
        /**/
        return $out;
    }

    static function repare_for_tpl($param) {
        /**
         * Генерация входных параметров компонента по умолчанию . Только Для визуального редактора и только для встроенного шаблона колесо
         * Входной массив исходный текущие значения параметров компонента
         * @var array $param
         */
        $out = $param;
        $out["ALL_BLOK"] = "7";
        $out["CLASS_OR_ID1"] = ".p-pokrishka";
        $out["CLASS_OR_ID2"] = ".p-disk";
        $out["CLASS_OR_ID3"] = ".p-pokrishka";
        $out["CLASS_OR_ID4"] = ".p-disk";
        $out["CLASS_OR_ID5"] = ".p-plashka1,.p-plashka2,.p-plashka3,.p-plashka4";

        $out["CLASS_OR_ID6"] = ".p-disk";
        $out["CLASS_OR_ID7"] = ".mult-1";
        $out["DSPIC6"] = GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_DISK_PO");
        $out["DSPIC7"] = GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_SDVIG_FONA");
        $out["EFFECT6"] = array(0=>"rotate_y",);
        $out["EFFECT7"] = array(0=>"bg_left",);
        $out["SPEED6"] = "0.3";
        $out["SPEED7"] = "40";
        $out["STOP_COUNT6"] = "10";
        $out["STOP_COUNT7"] = "";
        $out["ZADERJKA_ZW6"] = "1";
        $out["ZADERJKA_ZW7"] = "1";
        $out["START_ZADERJKA7"] = "5";


        $out["COMPONENT_TEMPLATE"] = "koleso";
        $out["DSPIC1"] = GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_POKRYSKA");
        $out["DSPIC2"] = GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_DISK");
        $out["DSPIC3"] = GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_POKRYSKA_POAVLENIE");
        $out["DSPIC4"] = GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_DISK_POAVLENIE");
        $out["DSPIC5"] = GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_PLASKI_POAVLENIE");
        $out["EFFECT1"] = array(0=>"circle_right",);
        $out["EFFECT2"] = array(0=>"circle_left",);
        $out["EFFECT3"] = array(0=>"opacity_up",);
        $out["EFFECT4"] = array(0=>"opacity_up",);
        $out["EFFECT5"] = array(0=>"opacity_up",);
        $out["PREFIX_CLASS"] = "pp0";
        $out["SPEED1"] = "8";
        $out["SPEED2"] = "16";
        $out["SPEED3"] = "4";
        $out["SPEED4"] = "1";
        $out["SPEED5"] = "4";
        $out["START_ZADERJKA1"] = "3";
        $out["START_ZADERJKA2"] = "3";
        $out["START_ZADERJKA3"] = "3";
        $out["START_ZADERJKA4"] = "1";
        $out["START_ZADERJKA5" ] = "4";
        $out["STOP_END1"] = "N";
        $out["STOP_END2"] = "N";
        $out["STOP_END3"] = "Y";
        $out["STOP_END4"] = "Y";
        $out["STOP_END5"] = "Y";
        $out["ZADERJKA_ZW1"] = "1";
        $out["ZADERJKA_ZW2"] = "1";
        $out["ZADERJKA_ZW3"] = "1";
        $out["ZADERJKA_ZW4"] = "1";
        $out["ZADERJKA_ZW5"] = "1";
        return $out;
    }
    static function repare_for_tpl_newyear($param) {
        /**
         * Генерация входных параметров компонента по умолчанию . Только Для визуального редактора и только для встроенного шаблона Новый Год
         * Входной массив исходный текущие значения параметров компонента
         * @var array $param
         */
        $out = $param;
        $out["ALL_BLOK"] = "2";
        $out["CLASS_OR_ID1"] = ".h";
        $out["CLASS_OR_ID2"] = ".m";
        $out["DSPIC1"] = GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_DS_NEWYEAR1");
        $out["DSPIC2"] = GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_DS_NEWYEAR2");
        $out["EFFECT1"] = array(0=>"circle_right",);
        $out["EFFECT2"] = array(0=>"circle_right",);
        $out["SPEED1"] = "144";
        $out["SPEED2"] = "12";
        $out["STOP_COUNT1"] = "";
        $out["STOP_COUNT2"] = "";
        $out["ZADERJKA_ZW1"] = "1";
        $out["ZADERJKA_ZW2"] = "1";
        $out["STOP_END1"] = "N";
        $out["STOP_END2"] = "N";

        $out["COLOR_ID1"] = "";
        $out["COLOR_ID2"] = "";
        return $out;
    }
    static function getAllblokForTpl($col,$param,$tpl) {
        /**
         * Только Для визуального редактора и только для встроенного шаблона колесо и только для первоначального вызова шаблона компонента
         * Это для учета особенности работы визуального редактора компонента именно при первом его(шаблона) вызове
         * Входной массив
         * @var array $param
         * Количество блоков изображений для встроенного шаблона колесо
         * @var int $col
         * Название шаблона компонента латиница
         * @var string $tpl
         */
        $fl_dbl = 0;
        if(isset($param['COMPONENT_TEMPLATE'])) {
            if(strlen($param['COMPONENT_TEMPLATE'])>0) {
                if($param['COMPONENT_TEMPLATE'] == "koleso") {
                    $fl_dbl = 1;
                    $fl_5 = 0;
                    if(isset($col)) {
                        if(strlen($col)>0) {
                            $fl_5 = 1;
                            $zz = $col;
                            $zz=(int)$zz;
                            if($zz<7) {
                                $col=7;
                            }
                        }
                    }
                    if($fl_5 === 0) {
                        $col=7;
                    }
                }
            }
        }
        if(isset($tpl) && $fl_dbl === 0) {
            if(strlen($tpl)>0) {
                if($tpl == "koleso") {
                    $fl_dbl = 1;
                    $fl_5 = 0;
                    if(isset($col)) {
                        if(strlen($col)>0) {
                            $fl_5 = 1;
                            $zz = $col;
                            $zz=(int)$zz;
                            if($zz<7) {
                                $col=7;
                            }
                        }
                    }
                    if($fl_5 === 0) {
                        $col=7;
                    }
                }
            }
        }
        return $col;

    }
    static function checkValidParam($arParams) {
        /**
         * Проверка правильности входных параметров компонента
         * Входной массив исходный текущие значения параметров компонента
         * @var array $arParams
         */
        $fl_show_no_class=COption::GetOptionString('directoriya.animatedgraphics', 'show_no_class');
        $out = Array("FL_ERR"=>0, "MSG_ERR"=>"");
        $max = trim($arParams['ALL_BLOK']);
        $max2 = preg_replace("/\D/","", $max);
        if(strlen($max) <> strlen($max2)) {
            $out["FL_ERR"] = 1;
            $out["MSG_ERR"] = GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_ERROR_NOT_NUMERIC");
        }
        $max = (int)$max;
        $iz = 1;
        for($iz = 1;$iz<=$max; $iz++) {
            $cls = trim($arParams["CLASS_OR_ID".$iz]);
            if(strlen($cls) === 0) {
                if(strlen($out["MSG_ERR"])===0) {
                    $out["MSG_ERR"] = GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_ERROR_NO_CLASS")." ".$iz;
                }else {
                    $out["MSG_ERR"] = $out["MSG_ERR"]."<br>".GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_ERROR_NO_CLASS")." ".$iz;
                }
                $out["FL_ERR"] = 1;
            }
            if(preg_match("/[\#\.]/", $cls) === 1 || preg_match("/[\#\.]/", $cls) ===true || $fl_show_no_class == "N" ) {
            }else {
                if(strlen($out["MSG_ERR"])===0) {
                    $out["MSG_ERR"] = GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_ERROR_NO_DIEZ")." ".$iz;
                }else {
                    $out["MSG_ERR"] = $out["MSG_ERR"]."<br>".GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_ERROR_NO_DIEZ")." ".$iz;
                }
                $out["FL_ERR"] = 1;
            }

            $ms_eff = $arParams["EFFECT".$iz];
            if(is_array($ms_eff)) {
                if (in_array('wolna_eff', $ms_eff)) {
                    $color = trim($arParams["COLOR_ID".$iz]);
                    if(strlen($color)===0) {
                        if(strlen($out["MSG_ERR"])===0) {
                            $out["MSG_ERR"] = GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_ERROR_NO_COLOR")." ".$iz;
                        }else {
                            $out["MSG_ERR"] = $out["MSG_ERR"]."<br>".GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_ERROR_NO_COLOR")." ".$iz;
                        }
                        $out["FL_ERR"] = 1;
                    }else {
                        $flLenColor = 0;
                        $flDiezColor = 0;
                        if(preg_match("/[\#]/", $color) === 1 || preg_match("/[\#]/", $color) ===true) {
                            $flDiezColor = 1;
                        }
                        if(strlen($color) === 7) {
                            $flLenColor = 1;
                        }
                        if($flDiezColor === 0 || $flLenColor === 0) {
                            if(strlen($out["MSG_ERR"])===0) {
                                $out["MSG_ERR"] = GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_ERROR_COLOR_FORMAT")." ".$iz;
                            }else {
                                $out["MSG_ERR"] = $out["MSG_ERR"]."<br>".GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_ERROR_COLOR_FORMAT")." ".$iz;
                            }
                            $out["FL_ERR"] = 1;
                        }

                    }
                }
                if (
                    in_array('rotate_repspective_x_1', $ms_eff) ||
                    in_array('rotate_repspective_x_2', $ms_eff) ||
                    in_array('rotate_repspective_y_1', $ms_eff) ||
                    in_array('rotate_repspective_y_2', $ms_eff)
                ) {
                    $parent = trim($arParams["PARENT_ID".$iz]);
                    /**/
                    if(strlen($parent) === 0) {
                        if(strlen($out["MSG_ERR"])===0) {
                            $out["MSG_ERR"] = GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_ERROR_NO_CLASS_PARENT")." ".$iz;
                        }else {
                            $out["MSG_ERR"] = $out["MSG_ERR"]."<br>".GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_ERROR_NO_CLASS_PARENT")." ".$iz;
                        }
                        $out["FL_ERR"] = 1;
                    }
                    if(preg_match("/[\#\.]/", $parent) === 1 || preg_match("/[\#\.]/", $parent) ===true  || $fl_show_no_class == "N") {
                    }else {
                        if(strlen($out["MSG_ERR"])===0) {
                            $out["MSG_ERR"] = GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_ERROR_NO_DIEZ_PARENT")." ".$iz;
                        }else {
                            $out["MSG_ERR"] = $out["MSG_ERR"]."<br>".GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_ERROR_NO_DIEZ_PARENT")." ".$iz;
                        }
                        $out["FL_ERR"] = 1;
                    }
                    /**/
                }

            }

            if(self::chekFloat($arParams["START_ZADERJKA".$iz]) ===1 ) {
                if (strlen($out["MSG_ERR"]) === 0) {
                    $out["MSG_ERR"] = GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_ERROR_NOT_FLOAT") . " " . $iz;
                } else {
                    $out["MSG_ERR"] = $out["MSG_ERR"] . "<br>" . GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_ERROR_NOT_FLOAT") . " " . $iz;
                }
                $out["FL_ERR"] = 1;
            }
            if(self::chekFloat($arParams["ZADERJKA_ZW".$iz]) ===1 ) {
                if (strlen($out["MSG_ERR"]) === 0) {
                    $out["MSG_ERR"] = GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_ERROR_NOT_FLOAT_ZW") . " " . $iz;
                } else {
                    $out["MSG_ERR"] = $out["MSG_ERR"] . "<br>" . GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_ERROR_NOT_FLOAT_ZW") . " " . $iz;
                }
                $out["FL_ERR"] = 1;
            }

            if(self::chekFloatNotEmpty($arParams["SPEED".$iz]) ===1 ) {
                    if (strlen($out["MSG_ERR"]) === 0) {
                        $out["MSG_ERR"] = GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_ERROR_NOT_FLOAT_SPEED") . " " . $iz;
                    } else {
                        $out["MSG_ERR"] = $out["MSG_ERR"] . "<br>" . GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_ERROR_NOT_FLOAT_SPEED") . " " . $iz;
                    }
                    $out["FL_ERR"] = 1;
            }

            if(self::chekInt($arParams["STOP_COUNT".$iz]) ===1 ) {
                if (strlen($out["MSG_ERR"]) === 0) {
                    $out["MSG_ERR"] = GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_ERROR_NOT_INT_COUNT") . " " . $iz;
                } else {
                    $out["MSG_ERR"] = $out["MSG_ERR"] . "<br>" . GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_ERROR_NOT_INT_COUNT") . " " . $iz;
                }
                $out["FL_ERR"] = 1;
            }


        }

        if($out["FL_ERR"] === 1) {
            $out["MSG_ERR"] = GetMessage("DIRECTORIYA_ANIMATEDGRAPHICS_ERROR_COMPONENT_NAME")."<br>".$out["MSG_ERR"];
        }
        return $out;
    }

    static function chekFloat($str) {
        /**
         * Проверка дробного числа. Пусто разрешено.
         * Входной параметр строка
         * @var string $str
         */
        $out = 0;
        if( is_numeric($str)) {
            $cpm = (float)$str;
            if( $cpm<0) {
                $out = 1;
            }

        }else {
            if(!isset($str) || $str == "") {
            }else{
                $out = 1;
            }
        }
        return $out;
    }
    static function chekFloatNotEmpty($str) {
        /**
         * Проверка дробного числа. Пусто НЕ разрешено.
         * Входной параметр строка
         * @var string $str
         */
        $out = 0;
        if( is_numeric($str)) {
            $cpm = (float)$str;
            if( $cpm<0) {
                $out = 1;
            }

        }else {
                $out = 1;
        }
        return $out;
    }
    static function chekInt($str) {
        /**
         * Проверка целого числа. Пусто разрешено.
         * Входной параметр строка
         * @var string $str
         */
        $out = 0;
        if( is_numeric($str)) {
            $cpm = (int)$str;
            if( $cpm<0) {
                $out = 1;
            }
            if(strlen($cpm) <> strlen($str)) {
                $out = 1;
            }

        }else {
            if(!isset($str) || $str == "") {
            }else{
                $out = 1;
            }
        }
        return $out;
    }
    static function getJsOnceEffectHelp() {
        $msOnce=self::getSelectBoxSingleEffect('allgrupp');
        $str = "[";
        $iz=0;
        foreach ($msOnce as $key=>$val) {
            if($iz === 0) {
                $str=$str.'"'.$key.'"';
            }else {
                $str=$str.', "'.$key.'"';
            }

            $iz++;
        }
        $str= $str."]";
        return $str;
    }
    static function getJsOnceEffectGruppHelp() {
        $ms_grupp = self::getGruppEffect();
        $str = "{";
        $iz=0;
        foreach ($ms_grupp as $key=>$val) {
            foreach ($val["CODE_EFF"] as $val2){
                if($iz === 0) {
                    $str=$str.'"'.$val2.'": "'.$key.'"';
                }else {
                    $str=$str.', "'.$val2.'": "'.$key.'"';
                }
                $iz++;
            }

        }
        $str= $str."}";
        return $str;
    }



}

?>